package de.flapdoodle.formula.values.domain;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.types.Id;
import de.flapdoodle.formula.values.properties.ReadOnlyProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReadOnlyValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReadOnlyValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableReadOnlyValue.of()}.
 */
@Generated(from = "ReadOnlyValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReadOnlyValue<O, T>
    extends ReadOnlyValue<O, T> {
  private final Id<O> id;
  private final ReadOnlyProperty<O, T> property;

  private ImmutableReadOnlyValue(
      Id<O> id,
      ReadOnlyProperty<O, T> property) {
    this.id = Objects.requireNonNull(id, "id");
    this.property = Objects.requireNonNull(property, "property");
  }

  private ImmutableReadOnlyValue(
      ImmutableReadOnlyValue<O, T> original,
      Id<O> id,
      ReadOnlyProperty<O, T> property) {
    this.id = id;
    this.property = property;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Id<O> id() {
    return id;
  }

  /**
   * @return The value of the {@code property} attribute
   */
  @Override
  protected ReadOnlyProperty<O, T> property() {
    return property;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReadOnlyValue#id() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReadOnlyValue<O, T> withId(Id<O> value) {
    if (this.id == value) return this;
    Id<O> newValue = Objects.requireNonNull(value, "id");
    return new ImmutableReadOnlyValue<>(this, newValue, this.property);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReadOnlyValue#property() property} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for property
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReadOnlyValue<O, T> withProperty(ReadOnlyProperty<O, T> value) {
    if (this.property == value) return this;
    ReadOnlyProperty<O, T> newValue = Objects.requireNonNull(value, "property");
    return new ImmutableReadOnlyValue<>(this, this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReadOnlyValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReadOnlyValue<?, ?>
        && equalTo(0, (ImmutableReadOnlyValue<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableReadOnlyValue<?, ?> another) {
    return id.equals(another.id)
        && property.equals(another.property);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code property}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + property.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReadOnlyValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ReadOnlyValue")
        .omitNullValues()
        .add("id", id)
        .add("property", property)
        .toString();
  }

  /**
   * Construct a new immutable {@code ReadOnlyValue} instance.
 * @param <O> generic parameter O
 * @param <T> generic parameter T
   * @param id The value for the {@code id} attribute
   * @param property The value for the {@code property} attribute
   * @return An immutable ReadOnlyValue instance
   */
  public static <O, T> ImmutableReadOnlyValue<O, T> of(Id<O> id, ReadOnlyProperty<O, T> property) {
    return new ImmutableReadOnlyValue<>(id, property);
  }

  /**
   * Creates an immutable copy of a {@link ReadOnlyValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ReadOnlyValue instance
   */
  public static <O, T> ImmutableReadOnlyValue<O, T> copyOf(ReadOnlyValue<O, T> instance) {
    if (instance instanceof ImmutableReadOnlyValue<?, ?>) {
      return (ImmutableReadOnlyValue<O, T>) instance;
    }
    return ImmutableReadOnlyValue.<O, T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReadOnlyValue ImmutableReadOnlyValue}.
   * <pre>
   * ImmutableReadOnlyValue.&amp;lt;O, T&amp;gt;builder()
   *    .id(de.flapdoodle.formula.types.Id&amp;lt;O&amp;gt;) // required {@link ReadOnlyValue#id() id}
   *    .property(de.flapdoodle.formula.values.properties.ReadOnlyProperty&amp;lt;O, T&amp;gt;) // required {@link ReadOnlyValue#property() property}
   *    .build();
   * </pre>
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @return A new ImmutableReadOnlyValue builder
   */
  public static <O, T> ImmutableReadOnlyValue.Builder<O, T> builder() {
    return new ImmutableReadOnlyValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableReadOnlyValue ImmutableReadOnlyValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReadOnlyValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O, T> {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_PROPERTY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Id<O> id;
    private @Nullable ReadOnlyProperty<O, T> property;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReadOnlyValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> from(ReadOnlyValue<O, T> instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      property(instance.property());
      return this;
    }

    /**
     * Initializes the value for the {@link ReadOnlyValue#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> id(Id<O> id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadOnlyValue#property() property} attribute.
     * @param property The value for property 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> property(ReadOnlyProperty<O, T> property) {
      this.property = Objects.requireNonNull(property, "property");
      initBits &= ~INIT_BIT_PROPERTY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReadOnlyValue ImmutableReadOnlyValue}.
     * @return An immutable instance of ReadOnlyValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReadOnlyValue<O, T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReadOnlyValue<>(null, id, property);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_PROPERTY) != 0) attributes.add("property");
      return "Cannot build ReadOnlyValue, some of required attributes are not set " + attributes;
    }
  }
}
