package de.flapdoodle.formula.values.domain;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.calculate.ValueLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ChangeableInstanceValueLookup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableChangeableInstanceValueLookup.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableChangeableInstanceValueLookup.of()}.
 */
@Generated(from = "ChangeableInstanceValueLookup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableChangeableInstanceValueLookup<O extends ChangeableInstance<O>>
    extends ChangeableInstanceValueLookup<O> {
  private final O instance;
  private final ValueLookup fallback;

  private ImmutableChangeableInstanceValueLookup(O instance, ValueLookup fallback) {
    this.instance = Objects.requireNonNull(instance, "instance");
    this.fallback = Objects.requireNonNull(fallback, "fallback");
  }

  private ImmutableChangeableInstanceValueLookup(
      ImmutableChangeableInstanceValueLookup<O> original,
      O instance,
      ValueLookup fallback) {
    this.instance = instance;
    this.fallback = fallback;
  }

  /**
   * @return The value of the {@code instance} attribute
   */
  @Override
  protected O instance() {
    return instance;
  }

  /**
   * @return The value of the {@code fallback} attribute
   */
  @Override
  protected ValueLookup fallback() {
    return fallback;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChangeableInstanceValueLookup#instance() instance} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instance
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChangeableInstanceValueLookup<O> withInstance(O value) {
    if (this.instance == value) return this;
    O newValue = Objects.requireNonNull(value, "instance");
    return new ImmutableChangeableInstanceValueLookup<>(this, newValue, this.fallback);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChangeableInstanceValueLookup#fallback() fallback} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fallback
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableChangeableInstanceValueLookup<O> withFallback(ValueLookup value) {
    if (this.fallback == value) return this;
    ValueLookup newValue = Objects.requireNonNull(value, "fallback");
    return new ImmutableChangeableInstanceValueLookup<>(this, this.instance, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableChangeableInstanceValueLookup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableChangeableInstanceValueLookup<?>
        && equalTo(0, (ImmutableChangeableInstanceValueLookup<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableChangeableInstanceValueLookup<?> another) {
    return instance.equals(another.instance)
        && fallback.equals(another.fallback);
  }

  /**
   * Computes a hash code from attributes: {@code instance}, {@code fallback}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + instance.hashCode();
    h += (h << 5) + fallback.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeableInstanceValueLookup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ChangeableInstanceValueLookup")
        .omitNullValues()
        .add("instance", instance)
        .add("fallback", fallback)
        .toString();
  }

  /**
   * Construct a new immutable {@code ChangeableInstanceValueLookup} instance.
 * @param <O> generic parameter O
   * @param instance The value for the {@code instance} attribute
   * @param fallback The value for the {@code fallback} attribute
   * @return An immutable ChangeableInstanceValueLookup instance
   */
  public static <O extends ChangeableInstance<O>> ImmutableChangeableInstanceValueLookup<O> of(O instance, ValueLookup fallback) {
    return new ImmutableChangeableInstanceValueLookup<>(instance, fallback);
  }

  /**
   * Creates an immutable copy of a {@link ChangeableInstanceValueLookup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param instance The instance to copy
   * @return A copied immutable ChangeableInstanceValueLookup instance
   */
  public static <O extends ChangeableInstance<O>> ImmutableChangeableInstanceValueLookup<O> copyOf(ChangeableInstanceValueLookup<O> instance) {
    if (instance instanceof ImmutableChangeableInstanceValueLookup<?>) {
      return (ImmutableChangeableInstanceValueLookup<O>) instance;
    }
    return ImmutableChangeableInstanceValueLookup.<O>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableChangeableInstanceValueLookup ImmutableChangeableInstanceValueLookup}.
   * <pre>
   * ImmutableChangeableInstanceValueLookup.&amp;lt;O&amp;gt;builder()
   *    .instance(O) // required {@link ChangeableInstanceValueLookup#instance() instance}
   *    .fallback(de.flapdoodle.formula.calculate.ValueLookup) // required {@link ChangeableInstanceValueLookup#fallback() fallback}
   *    .build();
   * </pre>
   * @param <O> generic parameter O
   * @return A new ImmutableChangeableInstanceValueLookup builder
   */
  public static <O extends ChangeableInstance<O>> ImmutableChangeableInstanceValueLookup.Builder<O> builder() {
    return new ImmutableChangeableInstanceValueLookup.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableChangeableInstanceValueLookup ImmutableChangeableInstanceValueLookup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ChangeableInstanceValueLookup", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O extends ChangeableInstance<O>> {
    private static final long INIT_BIT_INSTANCE = 0x1L;
    private static final long INIT_BIT_FALLBACK = 0x2L;
    private long initBits = 0x3L;

    private @Nullable O instance;
    private @Nullable ValueLookup fallback;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeableInstanceValueLookup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> from(ChangeableInstanceValueLookup<O> instance) {
      Objects.requireNonNull(instance, "instance");
      instance(instance.instance());
      fallback(instance.fallback());
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeableInstanceValueLookup#instance() instance} attribute.
     * @param instance The value for instance 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> instance(O instance) {
      this.instance = Objects.requireNonNull(instance, "instance");
      initBits &= ~INIT_BIT_INSTANCE;
      return this;
    }

    /**
     * Initializes the value for the {@link ChangeableInstanceValueLookup#fallback() fallback} attribute.
     * @param fallback The value for fallback 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> fallback(ValueLookup fallback) {
      this.fallback = Objects.requireNonNull(fallback, "fallback");
      initBits &= ~INIT_BIT_FALLBACK;
      return this;
    }

    /**
     * Builds a new {@link ImmutableChangeableInstanceValueLookup ImmutableChangeableInstanceValueLookup}.
     * @return An immutable instance of ChangeableInstanceValueLookup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableChangeableInstanceValueLookup<O> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableChangeableInstanceValueLookup<>(null, instance, fallback);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INSTANCE) != 0) attributes.add("instance");
      if ((initBits & INIT_BIT_FALLBACK) != 0) attributes.add("fallback");
      return "Cannot build ChangeableInstanceValueLookup, some of required attributes are not set " + attributes;
    }
  }
}
