package de.flapdoodle.formula.values;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Related}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelated.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRelated.of()}.
 */
@Generated(from = "Related", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelated<T, B> extends Related<T, B> {
  private final Value<T> destination;
  private final B reference;

  private ImmutableRelated(Value<T> destination, B reference) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.reference = Objects.requireNonNull(reference, "reference");
  }

  private ImmutableRelated(ImmutableRelated<T, B> original, Value<T> destination, B reference) {
    this.destination = destination;
    this.reference = reference;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  protected Value<T> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @Override
  protected B reference() {
    return reference;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Related#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelated<T, B> withDestination(Value<T> value) {
    if (this.destination == value) return this;
    Value<T> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableRelated<>(this, newValue, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Related#reference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelated<T, B> withReference(B value) {
    if (this.reference == value) return this;
    B newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableRelated<>(this, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelated} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelated<?, ?>
        && equalTo(0, (ImmutableRelated<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelated<?, ?> another) {
    return destination.equals(another.destination)
        && reference.equals(another.reference);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code reference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + reference.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Related} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Related")
        .omitNullValues()
        .add("destination", destination)
        .add("reference", reference)
        .toString();
  }

  /**
   * Construct a new immutable {@code Related} instance.
 * @param <T> generic parameter T
 * @param <B> generic parameter B
   * @param destination The value for the {@code destination} attribute
   * @param reference The value for the {@code reference} attribute
   * @return An immutable Related instance
   */
  public static <T, B> ImmutableRelated<T, B> of(Value<T> destination, B reference) {
    return new ImmutableRelated<>(destination, reference);
  }

  /**
   * Creates an immutable copy of a {@link Related} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <B> generic parameter B
   * @param instance The instance to copy
   * @return A copied immutable Related instance
   */
  public static <T, B> ImmutableRelated<T, B> copyOf(Related<T, B> instance) {
    if (instance instanceof ImmutableRelated<?, ?>) {
      return (ImmutableRelated<T, B>) instance;
    }
    return ImmutableRelated.<T, B>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelated ImmutableRelated}.
   * <pre>
   * ImmutableRelated.&amp;lt;T, B&amp;gt;builder()
   *    .destination(de.flapdoodle.formula.Value&amp;lt;T&amp;gt;) // required {@link Related#destination() destination}
   *    .reference(B) // required {@link Related#reference() reference}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <B> generic parameter B
   * @return A new ImmutableRelated builder
   */
  public static <T, B> ImmutableRelated.Builder<T, B> builder() {
    return new ImmutableRelated.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableRelated ImmutableRelated}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Related", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, B> {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_REFERENCE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Value<T> destination;
    private @Nullable B reference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Related} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, B> from(Related<T, B> instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.destination());
      reference(instance.reference());
      return this;
    }

    /**
     * Initializes the value for the {@link Related#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, B> destination(Value<T> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Related#reference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, B> reference(B reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelated ImmutableRelated}.
     * @return An immutable instance of Related
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelated<T, B> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelated<>(null, destination, reference);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build Related, some of required attributes are not set " + attributes;
    }
  }
}
