package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link V4.V4Explained}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableV4Explained.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableV4Explained.of()}.
 */
@Generated(from = "V4.V4Explained", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableV4Explained<T, A, B, C, D>
    extends V4.V4Explained<T, A, B, C, D> {
  private final V4<T, A, B, C, D> delegate;
  private final String humanReadable;

  private ImmutableV4Explained(
      V4<T, A, B, C, D> delegate,
      String humanReadable) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
  }

  private ImmutableV4Explained(
      ImmutableV4Explained<T, A, B, C, D> original,
      V4<T, A, B, C, D> delegate,
      String humanReadable) {
    this.delegate = delegate;
    this.humanReadable = humanReadable;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected V4<T, A, B, C, D> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code humanReadable} attribute
   */
  @Override
  protected String humanReadable() {
    return humanReadable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link V4.V4Explained#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV4Explained<T, A, B, C, D> withDelegate(V4<T, A, B, C, D> value) {
    if (this.delegate == value) return this;
    V4<T, A, B, C, D> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableV4Explained<>(this, newValue, this.humanReadable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link V4.V4Explained#humanReadable() humanReadable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for humanReadable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV4Explained<T, A, B, C, D> withHumanReadable(String value) {
    String newValue = Objects.requireNonNull(value, "humanReadable");
    if (this.humanReadable.equals(newValue)) return this;
    return new ImmutableV4Explained<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableV4Explained} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableV4Explained<?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableV4Explained<?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableV4Explained<?, ?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && humanReadable.equals(another.humanReadable);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code humanReadable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + humanReadable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code V4Explained} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("V4Explained")
        .omitNullValues()
        .add("delegate", delegate)
        .add("humanReadable", humanReadable)
        .toString();
  }

  /**
   * Construct a new immutable {@code V4Explained} instance.
 * @param <T> generic parameter T
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
   * @param delegate The value for the {@code delegate} attribute
   * @param humanReadable The value for the {@code humanReadable} attribute
   * @return An immutable V4Explained instance
   */
  public static <T, A, B, C, D> ImmutableV4Explained<T, A, B, C, D> of(V4<T, A, B, C, D> delegate, String humanReadable) {
    return new ImmutableV4Explained<>(delegate, humanReadable);
  }

  /**
   * Creates an immutable copy of a {@link V4.V4Explained} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable V4Explained instance
   */
  public static <T, A, B, C, D> ImmutableV4Explained<T, A, B, C, D> copyOf(V4.V4Explained<T, A, B, C, D> instance) {
    if (instance instanceof ImmutableV4Explained<?, ?, ?, ?, ?>) {
      return (ImmutableV4Explained<T, A, B, C, D>) instance;
    }
    return ImmutableV4Explained.<T, A, B, C, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableV4Explained ImmutableV4Explained}.
   * <pre>
   * ImmutableV4Explained.&amp;lt;T, A, B, C, D&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.validation.validations.V4&amp;lt;T, A, B, C, D&amp;gt;) // required {@link V4.V4Explained#delegate() delegate}
   *    .humanReadable(String) // required {@link V4.V4Explained#humanReadable() humanReadable}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @return A new ImmutableV4Explained builder
   */
  public static <T, A, B, C, D> ImmutableV4Explained.Builder<T, A, B, C, D> builder() {
    return new ImmutableV4Explained.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableV4Explained ImmutableV4Explained}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "V4.V4Explained", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, A, B, C, D> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_HUMAN_READABLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable V4<T, A, B, C, D> delegate;
    private @Nullable String humanReadable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code V4Explained} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C, D> from(V4.V4Explained<T, A, B, C, D> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      humanReadable(instance.humanReadable());
      return this;
    }

    /**
     * Initializes the value for the {@link V4.V4Explained#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C, D> delegate(V4<T, A, B, C, D> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link V4.V4Explained#humanReadable() humanReadable} attribute.
     * @param humanReadable The value for humanReadable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C, D> humanReadable(String humanReadable) {
      this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
      initBits &= ~INIT_BIT_HUMAN_READABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableV4Explained ImmutableV4Explained}.
     * @return An immutable instance of V4Explained
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableV4Explained<T, A, B, C, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableV4Explained<>(null, delegate, humanReadable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_HUMAN_READABLE) != 0) attributes.add("humanReadable");
      return "Cannot build V4Explained, some of required attributes are not set " + attributes;
    }
  }
}
