package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link V3.V3Explained}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableV3Explained.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableV3Explained.of()}.
 */
@Generated(from = "V3.V3Explained", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableV3Explained<T, A, B, C>
    extends V3.V3Explained<T, A, B, C> {
  private final V3<T, A, B, C> delegate;
  private final String humanReadable;

  private ImmutableV3Explained(
      V3<T, A, B, C> delegate,
      String humanReadable) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
  }

  private ImmutableV3Explained(
      ImmutableV3Explained<T, A, B, C> original,
      V3<T, A, B, C> delegate,
      String humanReadable) {
    this.delegate = delegate;
    this.humanReadable = humanReadable;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected V3<T, A, B, C> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code humanReadable} attribute
   */
  @Override
  protected String humanReadable() {
    return humanReadable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link V3.V3Explained#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV3Explained<T, A, B, C> withDelegate(V3<T, A, B, C> value) {
    if (this.delegate == value) return this;
    V3<T, A, B, C> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableV3Explained<>(this, newValue, this.humanReadable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link V3.V3Explained#humanReadable() humanReadable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for humanReadable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableV3Explained<T, A, B, C> withHumanReadable(String value) {
    String newValue = Objects.requireNonNull(value, "humanReadable");
    if (this.humanReadable.equals(newValue)) return this;
    return new ImmutableV3Explained<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableV3Explained} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableV3Explained<?, ?, ?, ?>
        && equalTo(0, (ImmutableV3Explained<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableV3Explained<?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && humanReadable.equals(another.humanReadable);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code humanReadable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + humanReadable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code V3Explained} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("V3Explained")
        .omitNullValues()
        .add("delegate", delegate)
        .add("humanReadable", humanReadable)
        .toString();
  }

  /**
   * Construct a new immutable {@code V3Explained} instance.
 * @param <T> generic parameter T
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
   * @param delegate The value for the {@code delegate} attribute
   * @param humanReadable The value for the {@code humanReadable} attribute
   * @return An immutable V3Explained instance
   */
  public static <T, A, B, C> ImmutableV3Explained<T, A, B, C> of(V3<T, A, B, C> delegate, String humanReadable) {
    return new ImmutableV3Explained<>(delegate, humanReadable);
  }

  /**
   * Creates an immutable copy of a {@link V3.V3Explained} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param instance The instance to copy
   * @return A copied immutable V3Explained instance
   */
  public static <T, A, B, C> ImmutableV3Explained<T, A, B, C> copyOf(V3.V3Explained<T, A, B, C> instance) {
    if (instance instanceof ImmutableV3Explained<?, ?, ?, ?>) {
      return (ImmutableV3Explained<T, A, B, C>) instance;
    }
    return ImmutableV3Explained.<T, A, B, C>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableV3Explained ImmutableV3Explained}.
   * <pre>
   * ImmutableV3Explained.&amp;lt;T, A, B, C&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.validation.validations.V3&amp;lt;T, A, B, C&amp;gt;) // required {@link V3.V3Explained#delegate() delegate}
   *    .humanReadable(String) // required {@link V3.V3Explained#humanReadable() humanReadable}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @return A new ImmutableV3Explained builder
   */
  public static <T, A, B, C> ImmutableV3Explained.Builder<T, A, B, C> builder() {
    return new ImmutableV3Explained.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableV3Explained ImmutableV3Explained}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "V3.V3Explained", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, A, B, C> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_HUMAN_READABLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable V3<T, A, B, C> delegate;
    private @Nullable String humanReadable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code V3Explained} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C> from(V3.V3Explained<T, A, B, C> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      humanReadable(instance.humanReadable());
      return this;
    }

    /**
     * Initializes the value for the {@link V3.V3Explained#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C> delegate(V3<T, A, B, C> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link V3.V3Explained#humanReadable() humanReadable} attribute.
     * @param humanReadable The value for humanReadable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, A, B, C> humanReadable(String humanReadable) {
      this.humanReadable = Objects.requireNonNull(humanReadable, "humanReadable");
      initBits &= ~INIT_BIT_HUMAN_READABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableV3Explained ImmutableV3Explained}.
     * @return An immutable instance of V3Explained
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableV3Explained<T, A, B, C> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableV3Explained<>(null, delegate, humanReadable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_HUMAN_READABLE) != 0) attributes.add("humanReadable");
      return "Cannot build V3Explained, some of required attributes are not set " + attributes;
    }
  }
}
