package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelatedTo4}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRelatedTo4.of()}.
 */
@Generated(from = "RelatedTo4", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelatedTo4<X, A, B, C, D>
    extends RelatedTo4<X, A, B, C, D> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final ValueSource<C> c;
  private final ValueSource<D> d;
  private final V4<X, A, B, C, D> validation;

  private ImmutableRelatedTo4(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      V4<X, A, B, C, D> validation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.d = Objects.requireNonNull(d, "d");
    this.validation = Objects.requireNonNull(validation, "validation");
  }

  private ImmutableRelatedTo4(
      ImmutableRelatedTo4<X, A, B, C, D> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      V4<X, A, B, C, D> validation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
    this.validation = validation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected ValueSource<C> c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  protected ValueSource<D> d() {
    return d;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  protected V4<X, A, B, C, D> validation() {
    return validation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableRelatedTo4<>(this, newValue, this.a, this.b, this.c, this.d, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableRelatedTo4<>(this, this.destination, newValue, this.b, this.c, this.d, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableRelatedTo4<>(this, this.destination, this.a, newValue, this.c, this.d, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withC(ValueSource<C> value) {
    if (this.c == value) return this;
    ValueSource<C> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableRelatedTo4<>(this, this.destination, this.a, this.b, newValue, this.d, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#d() d} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withD(ValueSource<D> value) {
    if (this.d == value) return this;
    ValueSource<D> newValue = Objects.requireNonNull(value, "d");
    return new ImmutableRelatedTo4<>(this, this.destination, this.a, this.b, this.c, newValue, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo4#validation() validation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo4<X, A, B, C, D> withValidation(V4<X, A, B, C, D> value) {
    if (this.validation == value) return this;
    V4<X, A, B, C, D> newValue = Objects.requireNonNull(value, "validation");
    return new ImmutableRelatedTo4<>(this, this.destination, this.a, this.b, this.c, this.d, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelatedTo4} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelatedTo4<?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableRelatedTo4<?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelatedTo4<?, ?, ?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d)
        && validation.equals(another.validation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code c}, {@code d}, {@code validation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    h += (h << 5) + validation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelatedTo4} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RelatedTo4")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .add("validation", validation)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long SOURCES_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Set<ValueSource<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link RelatedTo4#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<ValueSource<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Construct a new immutable {@code RelatedTo4} instance.
 * @param <X> generic parameter X
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param d The value for the {@code d} attribute
   * @param validation The value for the {@code validation} attribute
   * @return An immutable RelatedTo4 instance
   */
  public static <X, A, B, C, D> ImmutableRelatedTo4<X, A, B, C, D> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, ValueSource<D> d, V4<X, A, B, C, D> validation) {
    return new ImmutableRelatedTo4<>(destination, a, b, c, d, validation);
  }

  /**
   * Creates an immutable copy of a {@link RelatedTo4} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable RelatedTo4 instance
   */
  public static <X, A, B, C, D> ImmutableRelatedTo4<X, A, B, C, D> copyOf(RelatedTo4<X, A, B, C, D> instance) {
    if (instance instanceof ImmutableRelatedTo4<?, ?, ?, ?, ?>) {
      return (ImmutableRelatedTo4<X, A, B, C, D>) instance;
    }
    return ImmutableRelatedTo4.<X, A, B, C, D>of(instance.destination(), instance.a(), instance.b(), instance.c(), instance.d(), instance.validation());
  }
}
