package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelatedTo3}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRelatedTo3.of()}.
 */
@Generated(from = "RelatedTo3", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelatedTo3<X, A, B, C>
    extends RelatedTo3<X, A, B, C> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final ValueSource<C> c;
  private final V3<X, A, B, C> validation;

  private ImmutableRelatedTo3(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      V3<X, A, B, C> validation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.validation = Objects.requireNonNull(validation, "validation");
  }

  private ImmutableRelatedTo3(
      ImmutableRelatedTo3<X, A, B, C> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      V3<X, A, B, C> validation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.c = c;
    this.validation = validation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected ValueSource<C> c() {
    return c;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  protected V3<X, A, B, C> validation() {
    return validation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo3#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo3<X, A, B, C> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableRelatedTo3<>(this, newValue, this.a, this.b, this.c, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo3#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo3<X, A, B, C> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableRelatedTo3<>(this, this.destination, newValue, this.b, this.c, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo3#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo3<X, A, B, C> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableRelatedTo3<>(this, this.destination, this.a, newValue, this.c, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo3#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo3<X, A, B, C> withC(ValueSource<C> value) {
    if (this.c == value) return this;
    ValueSource<C> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableRelatedTo3<>(this, this.destination, this.a, this.b, newValue, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo3#validation() validation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo3<X, A, B, C> withValidation(V3<X, A, B, C> value) {
    if (this.validation == value) return this;
    V3<X, A, B, C> newValue = Objects.requireNonNull(value, "validation");
    return new ImmutableRelatedTo3<>(this, this.destination, this.a, this.b, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelatedTo3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelatedTo3<?, ?, ?, ?>
        && equalTo(0, (ImmutableRelatedTo3<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelatedTo3<?, ?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && validation.equals(another.validation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code c}, {@code validation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + validation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelatedTo3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RelatedTo3")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("validation", validation)
        .toString();
  }

  /**
   * Construct a new immutable {@code RelatedTo3} instance.
 * @param <X> generic parameter X
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param validation The value for the {@code validation} attribute
   * @return An immutable RelatedTo3 instance
   */
  public static <X, A, B, C> ImmutableRelatedTo3<X, A, B, C> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, V3<X, A, B, C> validation) {
    return new ImmutableRelatedTo3<>(destination, a, b, c, validation);
  }

  /**
   * Creates an immutable copy of a {@link RelatedTo3} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param instance The instance to copy
   * @return A copied immutable RelatedTo3 instance
   */
  public static <X, A, B, C> ImmutableRelatedTo3<X, A, B, C> copyOf(RelatedTo3<X, A, B, C> instance) {
    if (instance instanceof ImmutableRelatedTo3<?, ?, ?, ?>) {
      return (ImmutableRelatedTo3<X, A, B, C>) instance;
    }
    return ImmutableRelatedTo3.<X, A, B, C>of(instance.destination(), instance.a(), instance.b(), instance.c(), instance.validation());
  }
}
