package de.flapdoodle.formula.validation.validations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelatedTo2}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRelatedTo2.of()}.
 */
@Generated(from = "RelatedTo2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelatedTo2<X, A, B>
    extends RelatedTo2<X, A, B> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final V2<X, A, B> validation;

  private ImmutableRelatedTo2(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      V2<X, A, B> validation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.validation = Objects.requireNonNull(validation, "validation");
  }

  private ImmutableRelatedTo2(
      ImmutableRelatedTo2<X, A, B> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      V2<X, A, B> validation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.validation = validation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  protected V2<X, A, B> validation() {
    return validation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo2#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo2<X, A, B> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableRelatedTo2<>(this, newValue, this.a, this.b, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo2#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo2<X, A, B> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableRelatedTo2<>(this, this.destination, newValue, this.b, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo2#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo2<X, A, B> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableRelatedTo2<>(this, this.destination, this.a, newValue, this.validation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelatedTo2#validation() validation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelatedTo2<X, A, B> withValidation(V2<X, A, B> value) {
    if (this.validation == value) return this;
    V2<X, A, B> newValue = Objects.requireNonNull(value, "validation");
    return new ImmutableRelatedTo2<>(this, this.destination, this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelatedTo2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelatedTo2<?, ?, ?>
        && equalTo(0, (ImmutableRelatedTo2<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelatedTo2<?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && validation.equals(another.validation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code validation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + validation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelatedTo2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RelatedTo2")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("validation", validation)
        .toString();
  }

  /**
   * Construct a new immutable {@code RelatedTo2} instance.
 * @param <X> generic parameter X
 * @param <A> generic parameter A
 * @param <B> generic parameter B
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param validation The value for the {@code validation} attribute
   * @return An immutable RelatedTo2 instance
   */
  public static <X, A, B> ImmutableRelatedTo2<X, A, B> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, V2<X, A, B> validation) {
    return new ImmutableRelatedTo2<>(destination, a, b, validation);
  }

  /**
   * Creates an immutable copy of a {@link RelatedTo2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param instance The instance to copy
   * @return A copied immutable RelatedTo2 instance
   */
  public static <X, A, B> ImmutableRelatedTo2<X, A, B> copyOf(RelatedTo2<X, A, B> instance) {
    if (instance instanceof ImmutableRelatedTo2<?, ?, ?>) {
      return (ImmutableRelatedTo2<X, A, B>) instance;
    }
    return ImmutableRelatedTo2.<X, A, B>of(instance.destination(), instance.a(), instance.b(), instance.validation());
  }
}
