package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.ValueSource;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValidationError}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValidationError.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValidationError.of()}.
 */
@Generated(from = "ValidationError", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValidationError implements ValidationError {
  private final ImmutableList<ErrorMessage> errorMessages;
  private final ImmutableSet<ValueSource<?>> invalidReferences;

  private ImmutableValidationError(
      Iterable<? extends ErrorMessage> errorMessages,
      Iterable<? extends ValueSource<?>> invalidReferences) {
    this.errorMessages = ImmutableList.copyOf(errorMessages);
    this.invalidReferences = ImmutableSet.copyOf(invalidReferences);
  }

  private ImmutableValidationError(
      ImmutableValidationError original,
      ImmutableList<ErrorMessage> errorMessages,
      ImmutableSet<ValueSource<?>> invalidReferences) {
    this.errorMessages = errorMessages;
    this.invalidReferences = invalidReferences;
  }

  /**
   * @return The value of the {@code errorMessages} attribute
   */
  @Override
  public ImmutableList<ErrorMessage> errorMessages() {
    return errorMessages;
  }

  /**
   * @return The value of the {@code invalidReferences} attribute
   */
  @Override
  public ImmutableSet<ValueSource<?>> invalidReferences() {
    return invalidReferences;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationError#errorMessages() errorMessages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValidationError withErrorMessages(ErrorMessage... elements) {
    ImmutableList<ErrorMessage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableValidationError(this, newValue, this.invalidReferences);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationError#errorMessages() errorMessages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errorMessages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValidationError withErrorMessages(Iterable<? extends ErrorMessage> elements) {
    if (this.errorMessages == elements) return this;
    ImmutableList<ErrorMessage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableValidationError(this, newValue, this.invalidReferences);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationError#invalidReferences() invalidReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableValidationError withInvalidReferences(ValueSource<?>... elements) {
    ImmutableSet<ValueSource<?>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableValidationError(this, this.errorMessages, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationError#invalidReferences() invalidReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of invalidReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValidationError withInvalidReferences(Iterable<? extends ValueSource<?>> elements) {
    if (this.invalidReferences == elements) return this;
    ImmutableSet<ValueSource<?>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableValidationError(this, this.errorMessages, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValidationError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValidationError
        && equalTo(0, (ImmutableValidationError) another);
  }

  private boolean equalTo(int synthetic, ImmutableValidationError another) {
    return errorMessages.equals(another.errorMessages)
        && invalidReferences.equals(another.invalidReferences);
  }

  /**
   * Computes a hash code from attributes: {@code errorMessages}, {@code invalidReferences}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + errorMessages.hashCode();
    h += (h << 5) + invalidReferences.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValidationError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValidationError")
        .omitNullValues()
        .add("errorMessages", errorMessages)
        .add("invalidReferences", invalidReferences)
        .toString();
  }

  /**
   * Construct a new immutable {@code ValidationError} instance.
   * @param errorMessages The value for the {@code errorMessages} attribute
   * @param invalidReferences The value for the {@code invalidReferences} attribute
   * @return An immutable ValidationError instance
   */
  public static ImmutableValidationError of(List<ErrorMessage> errorMessages, Set<ValueSource<?>> invalidReferences) {
    return of((Iterable<? extends ErrorMessage>) errorMessages, (Iterable<? extends ValueSource<?>>) invalidReferences);
  }

  /**
   * Construct a new immutable {@code ValidationError} instance.
   * @param errorMessages The value for the {@code errorMessages} attribute
   * @param invalidReferences The value for the {@code invalidReferences} attribute
   * @return An immutable ValidationError instance
   */
  public static ImmutableValidationError of(Iterable<? extends ErrorMessage> errorMessages, Iterable<? extends ValueSource<?>> invalidReferences) {
    return new ImmutableValidationError(errorMessages, invalidReferences);
  }

  /**
   * Creates an immutable copy of a {@link ValidationError} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValidationError instance
   */
  public static ImmutableValidationError copyOf(ValidationError instance) {
    if (instance instanceof ImmutableValidationError) {
      return (ImmutableValidationError) instance;
    }
    return ImmutableValidationError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValidationError ImmutableValidationError}.
   * <pre>
   * ImmutableValidationError.builder()
   *    .addErrorMessages|addAllErrorMessages(de.flapdoodle.formula.validation.ErrorMessage) // {@link ValidationError#errorMessages() errorMessages} elements
   *    .addInvalidReferences|addAllInvalidReferences(de.flapdoodle.formula.ValueSource&amp;lt;?&amp;gt;) // {@link ValidationError#invalidReferences() invalidReferences} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValidationError builder
   */
  public static ImmutableValidationError.Builder builder() {
    return new ImmutableValidationError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValidationError ImmutableValidationError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValidationError", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<ErrorMessage> errorMessages = ImmutableList.builder();
    private ImmutableSet.Builder<ValueSource<?>> invalidReferences = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValidationError} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValidationError instance) {
      Objects.requireNonNull(instance, "instance");
      addAllErrorMessages(instance.errorMessages());
      addAllInvalidReferences(instance.invalidReferences());
      return this;
    }

    /**
     * Adds one element to {@link ValidationError#errorMessages() errorMessages} list.
     * @param element A errorMessages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrorMessages(ErrorMessage element) {
      this.errorMessages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValidationError#errorMessages() errorMessages} list.
     * @param elements An array of errorMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrorMessages(ErrorMessage... elements) {
      this.errorMessages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValidationError#errorMessages() errorMessages} list.
     * @param elements An iterable of errorMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorMessages(Iterable<? extends ErrorMessage> elements) {
      this.errorMessages = ImmutableList.builder();
      return addAllErrorMessages(elements);
    }

    /**
     * Adds elements to {@link ValidationError#errorMessages() errorMessages} list.
     * @param elements An iterable of errorMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllErrorMessages(Iterable<? extends ErrorMessage> elements) {
      this.errorMessages.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ValidationError#invalidReferences() invalidReferences} set.
     * @param element A invalidReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInvalidReferences(ValueSource<?> element) {
      this.invalidReferences.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValidationError#invalidReferences() invalidReferences} set.
     * @param elements An array of invalidReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addInvalidReferences(ValueSource<?>... elements) {
      this.invalidReferences.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValidationError#invalidReferences() invalidReferences} set.
     * @param elements An iterable of invalidReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder invalidReferences(Iterable<? extends ValueSource<?>> elements) {
      this.invalidReferences = ImmutableSet.builder();
      return addAllInvalidReferences(elements);
    }

    /**
     * Adds elements to {@link ValidationError#invalidReferences() invalidReferences} set.
     * @param elements An iterable of invalidReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInvalidReferences(Iterable<? extends ValueSource<?>> elements) {
      this.invalidReferences.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableValidationError ImmutableValidationError}.
     * @return An immutable instance of ValidationError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValidationError build() {
      return new ImmutableValidationError(null, errorMessages.build(), invalidReferences.build());
    }
  }
}
