package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.ValueSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StrictValidatedValueLookup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStrictValidatedValueLookup.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStrictValidatedValueLookup.of()}.
 */
@Generated(from = "StrictValidatedValueLookup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStrictValidatedValueLookup
    extends StrictValidatedValueLookup {
  private final ImmutableList<ValidatedValue<?>> validatedValues;

  private ImmutableStrictValidatedValueLookup(Iterable<? extends ValidatedValue<?>> validatedValues) {
    this.validatedValues = ImmutableList.copyOf(validatedValues);
  }

  private ImmutableStrictValidatedValueLookup(
      ImmutableStrictValidatedValueLookup original,
      ImmutableList<ValidatedValue<?>> validatedValues) {
    this.validatedValues = validatedValues;
  }

  /**
   * @return The value of the {@code validatedValues} attribute
   */
  @Override
  protected ImmutableList<ValidatedValue<?>> validatedValues() {
    return validatedValues;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StrictValidatedValueLookup#validatedValues() validatedValues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableStrictValidatedValueLookup withValidatedValues(ValidatedValue<?>... elements) {
    ImmutableList<ValidatedValue<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableStrictValidatedValueLookup(this, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StrictValidatedValueLookup#validatedValues() validatedValues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of validatedValues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStrictValidatedValueLookup withValidatedValues(Iterable<? extends ValidatedValue<?>> elements) {
    if (this.validatedValues == elements) return this;
    ImmutableList<ValidatedValue<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableStrictValidatedValueLookup(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStrictValidatedValueLookup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStrictValidatedValueLookup
        && equalTo(0, (ImmutableStrictValidatedValueLookup) another);
  }

  private boolean equalTo(int synthetic, ImmutableStrictValidatedValueLookup another) {
    return validatedValues.equals(another.validatedValues);
  }

  /**
   * Computes a hash code from attributes: {@code validatedValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + validatedValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StrictValidatedValueLookup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StrictValidatedValueLookup")
        .omitNullValues()
        .add("validatedValues", validatedValues)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long VALIDATED_VALUE_MAP_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Map<ValueSource<?>, ValidatedValue<?>> validatedValueMap;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link StrictValidatedValueLookup#validatedValueMap() validatedValueMap} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code validatedValueMap} attribute
   */
  @Override
  protected Map<ValueSource<?>, ValidatedValue<?>> validatedValueMap() {
    if ((lazyInitBitmap & VALIDATED_VALUE_MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VALIDATED_VALUE_MAP_LAZY_INIT_BIT) == 0) {
          this.validatedValueMap = Objects.requireNonNull(super.validatedValueMap(), "validatedValueMap");
          lazyInitBitmap |= VALIDATED_VALUE_MAP_LAZY_INIT_BIT;
        }
      }
    }
    return validatedValueMap;
  }

  /**
   * Construct a new immutable {@code StrictValidatedValueLookup} instance.
   * @param validatedValues The value for the {@code validatedValues} attribute
   * @return An immutable StrictValidatedValueLookup instance
   */
  public static ImmutableStrictValidatedValueLookup of(List<ValidatedValue<?>> validatedValues) {
    return of((Iterable<? extends ValidatedValue<?>>) validatedValues);
  }

  /**
   * Construct a new immutable {@code StrictValidatedValueLookup} instance.
   * @param validatedValues The value for the {@code validatedValues} attribute
   * @return An immutable StrictValidatedValueLookup instance
   */
  public static ImmutableStrictValidatedValueLookup of(Iterable<? extends ValidatedValue<?>> validatedValues) {
    return validate(new ImmutableStrictValidatedValueLookup(validatedValues));
  }

  private static ImmutableStrictValidatedValueLookup validate(ImmutableStrictValidatedValueLookup instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link StrictValidatedValueLookup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StrictValidatedValueLookup instance
   */
  public static ImmutableStrictValidatedValueLookup copyOf(StrictValidatedValueLookup instance) {
    if (instance instanceof ImmutableStrictValidatedValueLookup) {
      return (ImmutableStrictValidatedValueLookup) instance;
    }
    return ImmutableStrictValidatedValueLookup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStrictValidatedValueLookup ImmutableStrictValidatedValueLookup}.
   * <pre>
   * ImmutableStrictValidatedValueLookup.builder()
   *    .addValidatedValues|addAllValidatedValues(de.flapdoodle.formula.validation.ValidatedValue&amp;lt;?&amp;gt;) // {@link StrictValidatedValueLookup#validatedValues() validatedValues} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStrictValidatedValueLookup builder
   */
  public static ImmutableStrictValidatedValueLookup.Builder builder() {
    return new ImmutableStrictValidatedValueLookup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStrictValidatedValueLookup ImmutableStrictValidatedValueLookup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StrictValidatedValueLookup", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<ValidatedValue<?>> validatedValues = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StrictValidatedValueLookup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StrictValidatedValueLookup instance) {
      Objects.requireNonNull(instance, "instance");
      addAllValidatedValues(instance.validatedValues());
      return this;
    }

    /**
     * Adds one element to {@link StrictValidatedValueLookup#validatedValues() validatedValues} list.
     * @param element A validatedValues element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValidatedValues(ValidatedValue<?> element) {
      this.validatedValues.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StrictValidatedValueLookup#validatedValues() validatedValues} list.
     * @param elements An array of validatedValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addValidatedValues(ValidatedValue<?>... elements) {
      this.validatedValues.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StrictValidatedValueLookup#validatedValues() validatedValues} list.
     * @param elements An iterable of validatedValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validatedValues(Iterable<? extends ValidatedValue<?>> elements) {
      this.validatedValues = ImmutableList.builder();
      return addAllValidatedValues(elements);
    }

    /**
     * Adds elements to {@link StrictValidatedValueLookup#validatedValues() validatedValues} list.
     * @param elements An iterable of validatedValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValidatedValues(Iterable<? extends ValidatedValue<?>> elements) {
      this.validatedValues.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStrictValidatedValueLookup ImmutableStrictValidatedValueLookup}.
     * @return An immutable instance of StrictValidatedValueLookup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStrictValidatedValueLookup build() {
      return ImmutableStrictValidatedValueLookup.validate(new ImmutableStrictValidatedValueLookup(null, validatedValues.build()));
    }
  }
}
