package de.flapdoodle.formula.types;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Id}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableId.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableId.of()}.
 */
@Generated(from = "Id", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableId<O> extends Id<O> {
  private final Class<O> type;
  private final int count;

  private ImmutableId(Class<O> type, int count) {
    this.type = Objects.requireNonNull(type, "type");
    this.count = count;
  }

  private ImmutableId(ImmutableId<O> original, Class<O> type, int count) {
    this.type = type;
    this.count = count;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  protected Class<O> type() {
    return type;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @Override
  protected int count() {
    return count;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Id#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableId<O> withType(Class<O> value) {
    if (this.type == value) return this;
    Class<O> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableId<>(this, newValue, this.count);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Id#count() count} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for count
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableId<O> withCount(int value) {
    if (this.count == value) return this;
    return new ImmutableId<>(this, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableId<?>
        && equalTo(0, (ImmutableId<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableId<?> another) {
    return type.equals(another.type)
        && count == another.count;
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code count}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + count;
    return h;
  }

  /**
   * Construct a new immutable {@code Id} instance.
 * @param <O> generic parameter O
   * @param type The value for the {@code type} attribute
   * @param count The value for the {@code count} attribute
   * @return An immutable Id instance
   */
  public static <O> ImmutableId<O> of(Class<O> type, int count) {
    return new ImmutableId<>(type, count);
  }

  /**
   * Creates an immutable copy of a {@link Id} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param instance The instance to copy
   * @return A copied immutable Id instance
   */
  public static <O> ImmutableId<O> copyOf(Id<O> instance) {
    if (instance instanceof ImmutableId<?>) {
      return (ImmutableId<O>) instance;
    }
    return ImmutableId.<O>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableId ImmutableId}.
   * <pre>
   * ImmutableId.&amp;lt;O&amp;gt;builder()
   *    .type(Class&amp;lt;O&amp;gt;) // required {@link Id#type() type}
   *    .count(int) // required {@link Id#count() count}
   *    .build();
   * </pre>
   * @param <O> generic parameter O
   * @return A new ImmutableId builder
   */
  public static <O> ImmutableId.Builder<O> builder() {
    return new ImmutableId.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableId ImmutableId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Id", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_COUNT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Class<O> type;
    private int count;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Id} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> from(Id<O> instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      count(instance.count());
      return this;
    }

    /**
     * Initializes the value for the {@link Id#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> type(Class<O> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Id#count() count} attribute.
     * @param count The value for count 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> count(int count) {
      this.count = count;
      initBits &= ~INIT_BIT_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableId ImmutableId}.
     * @return An immutable instance of Id
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableId<O> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableId<>(null, type, count);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_COUNT) != 0) attributes.add("count");
      return "Cannot build Id, some of required attributes are not set " + attributes;
    }
  }
}
