package de.flapdoodle.formula.solver;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.validation.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Explanation.ExplainValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExplainValue.builder()}.
 */
@Generated(from = "Explanation.ExplainValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExplainValue<T> extends Explanation.ExplainValue<T> {
  private final Value<T> destination;
  private final @Nullable Validation<T> validation;
  private final @Nullable Calculation<T> calculation;

  private ImmutableExplainValue(
      Value<T> destination,
      @Nullable Validation<T> validation,
      @Nullable Calculation<T> calculation) {
    this.destination = destination;
    this.validation = validation;
    this.calculation = calculation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<T> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code validation} attribute
   */
  @Override
  public Optional<Validation<T>> validation() {
    return Optional.ofNullable(validation);
  }

  /**
   * @return The value of the {@code calculation} attribute
   */
  @Override
  public Optional<Calculation<T>> calculation() {
    return Optional.ofNullable(calculation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Explanation.ExplainValue#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExplainValue<T> withDestination(Value<T> value) {
    if (this.destination == value) return this;
    Value<T> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableExplainValue<>(newValue, this.validation, this.calculation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Explanation.ExplainValue#validation() validation} attribute.
   * @param value The value for validation
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExplainValue<T> withValidation(Validation<T> value) {
    Validation<T> newValue = Objects.requireNonNull(value, "validation");
    if (this.validation == newValue) return this;
    return new ImmutableExplainValue<>(this.destination, newValue, this.calculation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Explanation.ExplainValue#validation() validation} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for validation
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableExplainValue<T> withValidation(Optional<? extends Validation<T>> optional) {
    @Nullable Validation<T> value = optional.orElse(null);
    if (this.validation == value) return this;
    return new ImmutableExplainValue<>(this.destination, value, this.calculation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Explanation.ExplainValue#calculation() calculation} attribute.
   * @param value The value for calculation
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExplainValue<T> withCalculation(Calculation<T> value) {
    Calculation<T> newValue = Objects.requireNonNull(value, "calculation");
    if (this.calculation == newValue) return this;
    return new ImmutableExplainValue<>(this.destination, this.validation, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Explanation.ExplainValue#calculation() calculation} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for calculation
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableExplainValue<T> withCalculation(Optional<? extends Calculation<T>> optional) {
    @Nullable Calculation<T> value = optional.orElse(null);
    if (this.calculation == value) return this;
    return new ImmutableExplainValue<>(this.destination, this.validation, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExplainValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExplainValue<?>
        && equalTo(0, (ImmutableExplainValue<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableExplainValue<?> another) {
    return destination.equals(another.destination)
        && Objects.equals(validation, another.validation)
        && Objects.equals(calculation, another.calculation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code validation}, {@code calculation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + Objects.hashCode(validation);
    h += (h << 5) + Objects.hashCode(calculation);
    return h;
  }

  /**
   * Prints the immutable value {@code ExplainValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExplainValue")
        .omitNullValues()
        .add("destination", destination)
        .add("validation", validation)
        .add("calculation", calculation)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Explanation.ExplainValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ExplainValue instance
   */
  public static <T> ImmutableExplainValue<T> copyOf(Explanation.ExplainValue<T> instance) {
    if (instance instanceof ImmutableExplainValue<?>) {
      return (ImmutableExplainValue<T>) instance;
    }
    return ImmutableExplainValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExplainValue ImmutableExplainValue}.
   * <pre>
   * ImmutableExplainValue.&amp;lt;T&amp;gt;builder()
   *    .destination(de.flapdoodle.formula.Value&amp;lt;T&amp;gt;) // required {@link Explanation.ExplainValue#destination() destination}
   *    .validation(de.flapdoodle.formula.validation.Validation&amp;lt;T&amp;gt;) // optional {@link Explanation.ExplainValue#validation() validation}
   *    .calculation(de.flapdoodle.formula.calculate.Calculation&amp;lt;T&amp;gt;) // optional {@link Explanation.ExplainValue#calculation() calculation}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableExplainValue builder
   */
  public static <T> ImmutableExplainValue.Builder<T> builder() {
    return new ImmutableExplainValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableExplainValue ImmutableExplainValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Explanation.ExplainValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Value<T> destination;
    private @Nullable Validation<T> validation;
    private @Nullable Calculation<T> calculation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExplainValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Explanation.ExplainValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.destination());
      Optional<Validation<T>> validationOptional = instance.validation();
      if (validationOptional.isPresent()) {
        validation(validationOptional);
      }
      Optional<Calculation<T>> calculationOptional = instance.calculation();
      if (calculationOptional.isPresent()) {
        calculation(calculationOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Explanation.ExplainValue#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> destination(Value<T> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the optional value {@link Explanation.ExplainValue#validation() validation} to validation.
     * @param validation The value for validation
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> validation(Validation<T> validation) {
      this.validation = Objects.requireNonNull(validation, "validation");
      return this;
    }

    /**
     * Initializes the optional value {@link Explanation.ExplainValue#validation() validation} to validation.
     * @param validation The value for validation
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> validation(Optional<? extends Validation<T>> validation) {
      this.validation = validation.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Explanation.ExplainValue#calculation() calculation} to calculation.
     * @param calculation The value for calculation
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> calculation(Calculation<T> calculation) {
      this.calculation = Objects.requireNonNull(calculation, "calculation");
      return this;
    }

    /**
     * Initializes the optional value {@link Explanation.ExplainValue#calculation() calculation} to calculation.
     * @param calculation The value for calculation
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> calculation(Optional<? extends Calculation<T>> calculation) {
      this.calculation = calculation.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExplainValue ImmutableExplainValue}.
     * @return An immutable instance of ExplainValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExplainValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExplainValue<>(destination, validation, calculation);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build ExplainValue, some of required attributes are not set " + attributes;
    }
  }
}
