package de.flapdoodle.formula.rules;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.validation.Validation;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValidationMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValidationMap.builder()}.
 */
@Generated(from = "ValidationMap", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValidationMap extends ValidationMap {
  private final ImmutableList<Validation<?>> all;

  private ImmutableValidationMap(ImmutableList<Validation<?>> all) {
    this.all = all;
  }

  /**
   * @return The value of the {@code all} attribute
   */
  @Override
  public ImmutableList<Validation<?>> all() {
    return all;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationMap#all() all}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableValidationMap withAll(Validation<?>... elements) {
    ImmutableList<Validation<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableValidationMap(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValidationMap#all() all}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of all elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValidationMap withAll(Iterable<? extends Validation<?>> elements) {
    if (this.all == elements) return this;
    ImmutableList<Validation<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableValidationMap(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValidationMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValidationMap
        && equalTo(0, (ImmutableValidationMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableValidationMap another) {
    return all.equals(another.all);
  }

  /**
   * Computes a hash code from attributes: {@code all}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + all.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValidationMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValidationMap")
        .omitNullValues()
        .add("all", all)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long MAP_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Map<Value<?>, Validation<?>> map;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidationMap#map() map} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code map} attribute
   */
  @Override
  protected Map<Value<?>, Validation<?>> map() {
    if ((lazyInitBitmap & MAP_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & MAP_LAZY_INIT_BIT) == 0) {
          this.map = Objects.requireNonNull(super.map(), "map");
          lazyInitBitmap |= MAP_LAZY_INIT_BIT;
        }
      }
    }
    return map;
  }

  private static final long KEYS_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient Set<Value<?>> keys;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ValidationMap#keys() keys} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code keys} attribute
   */
  @Override
  public Set<Value<?>> keys() {
    if ((lazyInitBitmap & KEYS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & KEYS_LAZY_INIT_BIT) == 0) {
          this.keys = Objects.requireNonNull(super.keys(), "keys");
          lazyInitBitmap |= KEYS_LAZY_INIT_BIT;
        }
      }
    }
    return keys;
  }

  private static ImmutableValidationMap validate(ImmutableValidationMap instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ValidationMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValidationMap instance
   */
  public static ImmutableValidationMap copyOf(ValidationMap instance) {
    if (instance instanceof ImmutableValidationMap) {
      return (ImmutableValidationMap) instance;
    }
    return ImmutableValidationMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValidationMap ImmutableValidationMap}.
   * <pre>
   * ImmutableValidationMap.builder()
   *    .addAll|addAllAll(de.flapdoodle.formula.validation.Validation&amp;lt;?&amp;gt;) // {@link ValidationMap#all() all} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValidationMap builder
   */
  public static ImmutableValidationMap.Builder builder() {
    return new ImmutableValidationMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValidationMap ImmutableValidationMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValidationMap", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Validation<?>> all = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValidationMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValidationMap instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAll(instance.all());
      return this;
    }

    /**
     * Adds one element to {@link ValidationMap#all() all} list.
     * @param element A all element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAll(Validation<?> element) {
      this.all.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValidationMap#all() all} list.
     * @param elements An array of all elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addAll(Validation<?>... elements) {
      this.all.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValidationMap#all() all} list.
     * @param elements An iterable of all elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder all(Iterable<? extends Validation<?>> elements) {
      this.all = ImmutableList.builder();
      return addAllAll(elements);
    }

    /**
     * Adds elements to {@link ValidationMap#all() all} list.
     * @param elements An iterable of all elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAll(Iterable<? extends Validation<?>> elements) {
      this.all.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableValidationMap ImmutableValidationMap}.
     * @return An immutable instance of ValidationMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValidationMap build() {
      return ImmutableValidationMap.validate(new ImmutableValidationMap(all.build()));
    }
  }
}
