package de.flapdoodle.formula.rules;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Rules}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRules.of()}.
 */
@Generated(from = "Rules", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRules extends Rules {
  private final CalculationMap calculations;
  private final ValidationMap validations;

  private ImmutableRules(
      CalculationMap calculations,
      ValidationMap validations) {
    this.calculations = Objects.requireNonNull(calculations, "calculations");
    this.validations = Objects.requireNonNull(validations, "validations");
  }

  private ImmutableRules(
      ImmutableRules original,
      CalculationMap calculations,
      ValidationMap validations) {
    this.calculations = calculations;
    this.validations = validations;
  }

  /**
   * @return The value of the {@code calculations} attribute
   */
  @Override
  public CalculationMap calculations() {
    return calculations;
  }

  /**
   * @return The value of the {@code validations} attribute
   */
  @Override
  public ValidationMap validations() {
    return validations;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Rules#calculations() calculations} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for calculations
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRules withCalculations(CalculationMap value) {
    if (this.calculations == value) return this;
    CalculationMap newValue = Objects.requireNonNull(value, "calculations");
    return new ImmutableRules(this, newValue, this.validations);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Rules#validations() validations} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validations
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRules withValidations(ValidationMap value) {
    if (this.validations == value) return this;
    ValidationMap newValue = Objects.requireNonNull(value, "validations");
    return new ImmutableRules(this, this.calculations, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRules} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRules
        && equalTo(0, (ImmutableRules) another);
  }

  private boolean equalTo(int synthetic, ImmutableRules another) {
    return calculations.equals(another.calculations)
        && validations.equals(another.validations);
  }

  /**
   * Computes a hash code from attributes: {@code calculations}, {@code validations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + calculations.hashCode();
    h += (h << 5) + validations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Rules} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Rules")
        .omitNullValues()
        .add("calculations", calculations)
        .add("validations", validations)
        .toString();
  }

  /**
   * Construct a new immutable {@code Rules} instance.
   * @param calculations The value for the {@code calculations} attribute
   * @param validations The value for the {@code validations} attribute
   * @return An immutable Rules instance
   */
  public static ImmutableRules of(CalculationMap calculations, ValidationMap validations) {
    return new ImmutableRules(calculations, validations);
  }

  /**
   * Creates an immutable copy of a {@link Rules} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Rules instance
   */
  public static ImmutableRules copyOf(Rules instance) {
    if (instance instanceof ImmutableRules) {
      return (ImmutableRules) instance;
    }
    return ImmutableRules.of(instance.calculations(), instance.validations());
  }
}
