package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN5.FN5wrapF5}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN5wrapF5.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN5wrapF5.of()}.
 */
@Generated(from = "FN5.FN5wrapF5", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN5wrapF5<A, B, C, D, E, R>
    extends FN5.FN5wrapF5<A, B, C, D, E, R> {
  private final F5<A, B, C, D, E, R> delegate;

  private ImmutableFN5wrapF5(F5<A, B, C, D, E, R> delegate) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
  }

  private ImmutableFN5wrapF5(
      ImmutableFN5wrapF5<A, B, C, D, E, R> original,
      F5<A, B, C, D, E, R> delegate) {
    this.delegate = delegate;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F5<A, B, C, D, E, R> delegate() {
    return delegate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN5.FN5wrapF5#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN5wrapF5<A, B, C, D, E, R> withDelegate(F5<A, B, C, D, E, R> value) {
    if (this.delegate == value) return this;
    F5<A, B, C, D, E, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN5wrapF5<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN5wrapF5} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN5wrapF5<?, ?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableFN5wrapF5<?, ?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN5wrapF5<?, ?, ?, ?, ?, ?> another) {
    return delegate.equals(another.delegate);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN5wrapF5} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN5wrapF5")
        .omitNullValues()
        .add("delegate", delegate)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN5wrapF5} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <E> generic parameter E
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @return An immutable FN5wrapF5 instance
   */
  public static <A, B, C, D, E, R> ImmutableFN5wrapF5<A, B, C, D, E, R> of(F5<A, B, C, D, E, R> delegate) {
    return new ImmutableFN5wrapF5<>(delegate);
  }

  /**
   * Creates an immutable copy of a {@link FN5.FN5wrapF5} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <E> generic parameter E
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN5wrapF5 instance
   */
  public static <A, B, C, D, E, R> ImmutableFN5wrapF5<A, B, C, D, E, R> copyOf(FN5.FN5wrapF5<A, B, C, D, E, R> instance) {
    if (instance instanceof ImmutableFN5wrapF5<?, ?, ?, ?, ?, ?>) {
      return (ImmutableFN5wrapF5<A, B, C, D, E, R>) instance;
    }
    return ImmutableFN5wrapF5.<A, B, C, D, E, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN5wrapF5 ImmutableFN5wrapF5}.
   * <pre>
   * ImmutableFN5wrapF5.&amp;lt;A, B, C, D, E, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F5&amp;lt;A, B, C, D, E, R&amp;gt;) // required {@link FN5.FN5wrapF5#delegate() delegate}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <E> generic parameter E
   * @param <R> generic parameter R
   * @return A new ImmutableFN5wrapF5 builder
   */
  public static <A, B, C, D, E, R> ImmutableFN5wrapF5.Builder<A, B, C, D, E, R> builder() {
    return new ImmutableFN5wrapF5.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN5wrapF5 ImmutableFN5wrapF5}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN5.FN5wrapF5", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, D, E, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable F5<A, B, C, D, E, R> delegate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN5wrapF5} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, E, R> from(FN5.FN5wrapF5<A, B, C, D, E, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      return this;
    }

    /**
     * Initializes the value for the {@link FN5.FN5wrapF5#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, E, R> delegate(F5<A, B, C, D, E, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN5wrapF5 ImmutableFN5wrapF5}.
     * @return An immutable instance of FN5wrapF5
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN5wrapF5<A, B, C, D, E, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN5wrapF5<>(null, delegate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      return "Cannot build FN5wrapF5, some of required attributes are not set " + attributes;
    }
  }
}
