package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN4.FN4wrapF4}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN4wrapF4.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN4wrapF4.of()}.
 */
@Generated(from = "FN4.FN4wrapF4", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN4wrapF4<A, B, C, D, R>
    extends FN4.FN4wrapF4<A, B, C, D, R> {
  private final F4<A, B, C, D, R> delegate;

  private ImmutableFN4wrapF4(F4<A, B, C, D, R> delegate) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
  }

  private ImmutableFN4wrapF4(
      ImmutableFN4wrapF4<A, B, C, D, R> original,
      F4<A, B, C, D, R> delegate) {
    this.delegate = delegate;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F4<A, B, C, D, R> delegate() {
    return delegate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4wrapF4#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4wrapF4<A, B, C, D, R> withDelegate(F4<A, B, C, D, R> value) {
    if (this.delegate == value) return this;
    F4<A, B, C, D, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN4wrapF4<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN4wrapF4} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN4wrapF4<?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableFN4wrapF4<?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN4wrapF4<?, ?, ?, ?, ?> another) {
    return delegate.equals(another.delegate);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN4wrapF4} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN4wrapF4")
        .omitNullValues()
        .add("delegate", delegate)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN4wrapF4} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @return An immutable FN4wrapF4 instance
   */
  public static <A, B, C, D, R> ImmutableFN4wrapF4<A, B, C, D, R> of(F4<A, B, C, D, R> delegate) {
    return new ImmutableFN4wrapF4<>(delegate);
  }

  /**
   * Creates an immutable copy of a {@link FN4.FN4wrapF4} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN4wrapF4 instance
   */
  public static <A, B, C, D, R> ImmutableFN4wrapF4<A, B, C, D, R> copyOf(FN4.FN4wrapF4<A, B, C, D, R> instance) {
    if (instance instanceof ImmutableFN4wrapF4<?, ?, ?, ?, ?>) {
      return (ImmutableFN4wrapF4<A, B, C, D, R>) instance;
    }
    return ImmutableFN4wrapF4.<A, B, C, D, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN4wrapF4 ImmutableFN4wrapF4}.
   * <pre>
   * ImmutableFN4wrapF4.&amp;lt;A, B, C, D, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F4&amp;lt;A, B, C, D, R&amp;gt;) // required {@link FN4.FN4wrapF4#delegate() delegate}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <R> generic parameter R
   * @return A new ImmutableFN4wrapF4 builder
   */
  public static <A, B, C, D, R> ImmutableFN4wrapF4.Builder<A, B, C, D, R> builder() {
    return new ImmutableFN4wrapF4.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN4wrapF4 ImmutableFN4wrapF4}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN4.FN4wrapF4", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, D, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable F4<A, B, C, D, R> delegate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN4wrapF4} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> from(FN4.FN4wrapF4<A, B, C, D, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4wrapF4#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> delegate(F4<A, B, C, D, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN4wrapF4 ImmutableFN4wrapF4}.
     * @return An immutable instance of FN4wrapF4
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN4wrapF4<A, B, C, D, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN4wrapF4<>(null, delegate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      return "Cannot build FN4wrapF4, some of required attributes are not set " + attributes;
    }
  }
}
