package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN4.FN4checkNull}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN4checkNull.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN4checkNull.of()}.
 */
@Generated(from = "FN4.FN4checkNull", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN4checkNull<A, B, C, D, R>
    extends FN4.FN4checkNull<A, B, C, D, R> {
  private final F4<A, B, C, D, R> delegate;
  private final String a;
  private final String b;
  private final String c;
  private final String d;

  private ImmutableFN4checkNull(
      F4<A, B, C, D, R> delegate,
      String a,
      String b,
      String c,
      String d) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.d = Objects.requireNonNull(d, "d");
  }

  private ImmutableFN4checkNull(
      ImmutableFN4checkNull<A, B, C, D, R> original,
      F4<A, B, C, D, R> delegate,
      String a,
      String b,
      String c,
      String d) {
    this.delegate = delegate;
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F4<A, B, C, D, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected String b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected String c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  protected String d() {
    return d;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4checkNull#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4checkNull<A, B, C, D, R> withDelegate(F4<A, B, C, D, R> value) {
    if (this.delegate == value) return this;
    F4<A, B, C, D, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN4checkNull<>(this, newValue, this.a, this.b, this.c, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4checkNull#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4checkNull<A, B, C, D, R> withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableFN4checkNull<>(this, this.delegate, newValue, this.b, this.c, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4checkNull#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4checkNull<A, B, C, D, R> withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableFN4checkNull<>(this, this.delegate, this.a, newValue, this.c, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4checkNull#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4checkNull<A, B, C, D, R> withC(String value) {
    String newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutableFN4checkNull<>(this, this.delegate, this.a, this.b, newValue, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN4.FN4checkNull#d() d} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN4checkNull<A, B, C, D, R> withD(String value) {
    String newValue = Objects.requireNonNull(value, "d");
    if (this.d.equals(newValue)) return this;
    return new ImmutableFN4checkNull<>(this, this.delegate, this.a, this.b, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN4checkNull} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN4checkNull<?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableFN4checkNull<?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN4checkNull<?, ?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code a}, {@code b}, {@code c}, {@code d}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN4checkNull} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN4checkNull")
        .omitNullValues()
        .add("delegate", delegate)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN4checkNull} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param d The value for the {@code d} attribute
   * @return An immutable FN4checkNull instance
   */
  public static <A, B, C, D, R> ImmutableFN4checkNull<A, B, C, D, R> of(F4<A, B, C, D, R> delegate, String a, String b, String c, String d) {
    return new ImmutableFN4checkNull<>(delegate, a, b, c, d);
  }

  /**
   * Creates an immutable copy of a {@link FN4.FN4checkNull} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN4checkNull instance
   */
  public static <A, B, C, D, R> ImmutableFN4checkNull<A, B, C, D, R> copyOf(FN4.FN4checkNull<A, B, C, D, R> instance) {
    if (instance instanceof ImmutableFN4checkNull<?, ?, ?, ?, ?>) {
      return (ImmutableFN4checkNull<A, B, C, D, R>) instance;
    }
    return ImmutableFN4checkNull.<A, B, C, D, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN4checkNull ImmutableFN4checkNull}.
   * <pre>
   * ImmutableFN4checkNull.&amp;lt;A, B, C, D, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F4&amp;lt;A, B, C, D, R&amp;gt;) // required {@link FN4.FN4checkNull#delegate() delegate}
   *    .a(String) // required {@link FN4.FN4checkNull#a() a}
   *    .b(String) // required {@link FN4.FN4checkNull#b() b}
   *    .c(String) // required {@link FN4.FN4checkNull#c() c}
   *    .d(String) // required {@link FN4.FN4checkNull#d() d}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <R> generic parameter R
   * @return A new ImmutableFN4checkNull builder
   */
  public static <A, B, C, D, R> ImmutableFN4checkNull.Builder<A, B, C, D, R> builder() {
    return new ImmutableFN4checkNull.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN4checkNull ImmutableFN4checkNull}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN4.FN4checkNull", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, D, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_A = 0x2L;
    private static final long INIT_BIT_B = 0x4L;
    private static final long INIT_BIT_C = 0x8L;
    private static final long INIT_BIT_D = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable F4<A, B, C, D, R> delegate;
    private @Nullable String a;
    private @Nullable String b;
    private @Nullable String c;
    private @Nullable String d;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN4checkNull} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> from(FN4.FN4checkNull<A, B, C, D, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      a(instance.a());
      b(instance.b());
      c(instance.c());
      d(instance.d());
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4checkNull#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> delegate(F4<A, B, C, D, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4checkNull#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4checkNull#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4checkNull#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> c(String c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link FN4.FN4checkNull#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, R> d(String d) {
      this.d = Objects.requireNonNull(d, "d");
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN4checkNull ImmutableFN4checkNull}.
     * @return An immutable instance of FN4checkNull
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN4checkNull<A, B, C, D, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN4checkNull<>(null, delegate, a, b, c, d);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      return "Cannot build FN4checkNull, some of required attributes are not set " + attributes;
    }
  }
}
