package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN3.FN3wrapF3}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN3wrapF3.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN3wrapF3.of()}.
 */
@Generated(from = "FN3.FN3wrapF3", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN3wrapF3<A, B, C, R>
    extends FN3.FN3wrapF3<A, B, C, R> {
  private final F3<A, B, C, R> delegate;

  private ImmutableFN3wrapF3(F3<A, B, C, R> delegate) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
  }

  private ImmutableFN3wrapF3(
      ImmutableFN3wrapF3<A, B, C, R> original,
      F3<A, B, C, R> delegate) {
    this.delegate = delegate;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F3<A, B, C, R> delegate() {
    return delegate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3wrapF3#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3wrapF3<A, B, C, R> withDelegate(F3<A, B, C, R> value) {
    if (this.delegate == value) return this;
    F3<A, B, C, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN3wrapF3<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN3wrapF3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN3wrapF3<?, ?, ?, ?>
        && equalTo(0, (ImmutableFN3wrapF3<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN3wrapF3<?, ?, ?, ?> another) {
    return delegate.equals(another.delegate);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN3wrapF3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN3wrapF3")
        .omitNullValues()
        .add("delegate", delegate)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN3wrapF3} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @return An immutable FN3wrapF3 instance
   */
  public static <A, B, C, R> ImmutableFN3wrapF3<A, B, C, R> of(F3<A, B, C, R> delegate) {
    return new ImmutableFN3wrapF3<>(delegate);
  }

  /**
   * Creates an immutable copy of a {@link FN3.FN3wrapF3} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN3wrapF3 instance
   */
  public static <A, B, C, R> ImmutableFN3wrapF3<A, B, C, R> copyOf(FN3.FN3wrapF3<A, B, C, R> instance) {
    if (instance instanceof ImmutableFN3wrapF3<?, ?, ?, ?>) {
      return (ImmutableFN3wrapF3<A, B, C, R>) instance;
    }
    return ImmutableFN3wrapF3.<A, B, C, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN3wrapF3 ImmutableFN3wrapF3}.
   * <pre>
   * ImmutableFN3wrapF3.&amp;lt;A, B, C, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F3&amp;lt;A, B, C, R&amp;gt;) // required {@link FN3.FN3wrapF3#delegate() delegate}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @return A new ImmutableFN3wrapF3 builder
   */
  public static <A, B, C, R> ImmutableFN3wrapF3.Builder<A, B, C, R> builder() {
    return new ImmutableFN3wrapF3.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN3wrapF3 ImmutableFN3wrapF3}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN3.FN3wrapF3", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable F3<A, B, C, R> delegate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN3wrapF3} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> from(FN3.FN3wrapF3<A, B, C, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3wrapF3#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> delegate(F3<A, B, C, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN3wrapF3 ImmutableFN3wrapF3}.
     * @return An immutable instance of FN3wrapF3
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN3wrapF3<A, B, C, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN3wrapF3<>(null, delegate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      return "Cannot build FN3wrapF3, some of required attributes are not set " + attributes;
    }
  }
}
