package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN3.FN3checkNull}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN3checkNull.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN3checkNull.of()}.
 */
@Generated(from = "FN3.FN3checkNull", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN3checkNull<A, B, C, R>
    extends FN3.FN3checkNull<A, B, C, R> {
  private final F3<A, B, C, R> delegate;
  private final String a;
  private final String b;
  private final String c;

  private ImmutableFN3checkNull(
      F3<A, B, C, R> delegate,
      String a,
      String b,
      String c) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
  }

  private ImmutableFN3checkNull(
      ImmutableFN3checkNull<A, B, C, R> original,
      F3<A, B, C, R> delegate,
      String a,
      String b,
      String c) {
    this.delegate = delegate;
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F3<A, B, C, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected String b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected String c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3checkNull#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3checkNull<A, B, C, R> withDelegate(F3<A, B, C, R> value) {
    if (this.delegate == value) return this;
    F3<A, B, C, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN3checkNull<>(this, newValue, this.a, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3checkNull#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3checkNull<A, B, C, R> withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableFN3checkNull<>(this, this.delegate, newValue, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3checkNull#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3checkNull<A, B, C, R> withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableFN3checkNull<>(this, this.delegate, this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN3.FN3checkNull#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN3checkNull<A, B, C, R> withC(String value) {
    String newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutableFN3checkNull<>(this, this.delegate, this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN3checkNull} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN3checkNull<?, ?, ?, ?>
        && equalTo(0, (ImmutableFN3checkNull<?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN3checkNull<?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN3checkNull} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN3checkNull")
        .omitNullValues()
        .add("delegate", delegate)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN3checkNull} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @return An immutable FN3checkNull instance
   */
  public static <A, B, C, R> ImmutableFN3checkNull<A, B, C, R> of(F3<A, B, C, R> delegate, String a, String b, String c) {
    return new ImmutableFN3checkNull<>(delegate, a, b, c);
  }

  /**
   * Creates an immutable copy of a {@link FN3.FN3checkNull} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN3checkNull instance
   */
  public static <A, B, C, R> ImmutableFN3checkNull<A, B, C, R> copyOf(FN3.FN3checkNull<A, B, C, R> instance) {
    if (instance instanceof ImmutableFN3checkNull<?, ?, ?, ?>) {
      return (ImmutableFN3checkNull<A, B, C, R>) instance;
    }
    return ImmutableFN3checkNull.<A, B, C, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN3checkNull ImmutableFN3checkNull}.
   * <pre>
   * ImmutableFN3checkNull.&amp;lt;A, B, C, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F3&amp;lt;A, B, C, R&amp;gt;) // required {@link FN3.FN3checkNull#delegate() delegate}
   *    .a(String) // required {@link FN3.FN3checkNull#a() a}
   *    .b(String) // required {@link FN3.FN3checkNull#b() b}
   *    .c(String) // required {@link FN3.FN3checkNull#c() c}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <R> generic parameter R
   * @return A new ImmutableFN3checkNull builder
   */
  public static <A, B, C, R> ImmutableFN3checkNull.Builder<A, B, C, R> builder() {
    return new ImmutableFN3checkNull.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN3checkNull ImmutableFN3checkNull}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN3.FN3checkNull", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_A = 0x2L;
    private static final long INIT_BIT_B = 0x4L;
    private static final long INIT_BIT_C = 0x8L;
    private long initBits = 0xfL;

    private @Nullable F3<A, B, C, R> delegate;
    private @Nullable String a;
    private @Nullable String b;
    private @Nullable String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN3checkNull} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> from(FN3.FN3checkNull<A, B, C, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3checkNull#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> delegate(F3<A, B, C, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3checkNull#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3checkNull#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link FN3.FN3checkNull#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, R> c(String c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN3checkNull ImmutableFN3checkNull}.
     * @return An immutable instance of FN3checkNull
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN3checkNull<A, B, C, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN3checkNull<>(null, delegate, a, b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build FN3checkNull, some of required attributes are not set " + attributes;
    }
  }
}
