package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN2.FN2checkNull}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN2checkNull.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN2checkNull.of()}.
 */
@Generated(from = "FN2.FN2checkNull", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN2checkNull<A, B, R>
    extends FN2.FN2checkNull<A, B, R> {
  private final F2<A, B, R> delegate;
  private final String a;
  private final String b;

  private ImmutableFN2checkNull(
      F2<A, B, R> delegate,
      String a,
      String b) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
  }

  private ImmutableFN2checkNull(
      ImmutableFN2checkNull<A, B, R> original,
      F2<A, B, R> delegate,
      String a,
      String b) {
    this.delegate = delegate;
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F2<A, B, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected String b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN2.FN2checkNull#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN2checkNull<A, B, R> withDelegate(F2<A, B, R> value) {
    if (this.delegate == value) return this;
    F2<A, B, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN2checkNull<>(this, newValue, this.a, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN2.FN2checkNull#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN2checkNull<A, B, R> withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableFN2checkNull<>(this, this.delegate, newValue, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN2.FN2checkNull#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN2checkNull<A, B, R> withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableFN2checkNull<>(this, this.delegate, this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN2checkNull} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN2checkNull<?, ?, ?>
        && equalTo(0, (ImmutableFN2checkNull<?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN2checkNull<?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN2checkNull} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN2checkNull")
        .omitNullValues()
        .add("delegate", delegate)
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN2checkNull} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @return An immutable FN2checkNull instance
   */
  public static <A, B, R> ImmutableFN2checkNull<A, B, R> of(F2<A, B, R> delegate, String a, String b) {
    return new ImmutableFN2checkNull<>(delegate, a, b);
  }

  /**
   * Creates an immutable copy of a {@link FN2.FN2checkNull} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN2checkNull instance
   */
  public static <A, B, R> ImmutableFN2checkNull<A, B, R> copyOf(FN2.FN2checkNull<A, B, R> instance) {
    if (instance instanceof ImmutableFN2checkNull<?, ?, ?>) {
      return (ImmutableFN2checkNull<A, B, R>) instance;
    }
    return ImmutableFN2checkNull.<A, B, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN2checkNull ImmutableFN2checkNull}.
   * <pre>
   * ImmutableFN2checkNull.&amp;lt;A, B, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F2&amp;lt;A, B, R&amp;gt;) // required {@link FN2.FN2checkNull#delegate() delegate}
   *    .a(String) // required {@link FN2.FN2checkNull#a() a}
   *    .b(String) // required {@link FN2.FN2checkNull#b() b}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <R> generic parameter R
   * @return A new ImmutableFN2checkNull builder
   */
  public static <A, B, R> ImmutableFN2checkNull.Builder<A, B, R> builder() {
    return new ImmutableFN2checkNull.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN2checkNull ImmutableFN2checkNull}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN2.FN2checkNull", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_A = 0x2L;
    private static final long INIT_BIT_B = 0x4L;
    private long initBits = 0x7L;

    private @Nullable F2<A, B, R> delegate;
    private @Nullable String a;
    private @Nullable String b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN2checkNull} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> from(FN2.FN2checkNull<A, B, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link FN2.FN2checkNull#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> delegate(F2<A, B, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link FN2.FN2checkNull#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link FN2.FN2checkNull#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, R> b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN2checkNull ImmutableFN2checkNull}.
     * @return An immutable instance of FN2checkNull
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN2checkNull<A, B, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN2checkNull<>(null, delegate, a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build FN2checkNull, some of required attributes are not set " + attributes;
    }
  }
}
