package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN1.FN1wrapF1}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN1wrapF1.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN1wrapF1.of()}.
 */
@Generated(from = "FN1.FN1wrapF1", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN1wrapF1<A, R>
    extends FN1.FN1wrapF1<A, R> {
  private final F1<A, R> delegate;

  private ImmutableFN1wrapF1(F1<A, R> delegate) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
  }

  private ImmutableFN1wrapF1(ImmutableFN1wrapF1<A, R> original, F1<A, R> delegate) {
    this.delegate = delegate;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F1<A, R> delegate() {
    return delegate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN1.FN1wrapF1#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN1wrapF1<A, R> withDelegate(F1<A, R> value) {
    if (this.delegate == value) return this;
    F1<A, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN1wrapF1<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN1wrapF1} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN1wrapF1<?, ?>
        && equalTo(0, (ImmutableFN1wrapF1<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN1wrapF1<?, ?> another) {
    return delegate.equals(another.delegate);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN1wrapF1} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN1wrapF1")
        .omitNullValues()
        .add("delegate", delegate)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN1wrapF1} instance.
 * @param <A> generic parameter A
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @return An immutable FN1wrapF1 instance
   */
  public static <A, R> ImmutableFN1wrapF1<A, R> of(F1<A, R> delegate) {
    return new ImmutableFN1wrapF1<>(delegate);
  }

  /**
   * Creates an immutable copy of a {@link FN1.FN1wrapF1} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN1wrapF1 instance
   */
  public static <A, R> ImmutableFN1wrapF1<A, R> copyOf(FN1.FN1wrapF1<A, R> instance) {
    if (instance instanceof ImmutableFN1wrapF1<?, ?>) {
      return (ImmutableFN1wrapF1<A, R>) instance;
    }
    return ImmutableFN1wrapF1.<A, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN1wrapF1 ImmutableFN1wrapF1}.
   * <pre>
   * ImmutableFN1wrapF1.&amp;lt;A, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F1&amp;lt;A, R&amp;gt;) // required {@link FN1.FN1wrapF1#delegate() delegate}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @return A new ImmutableFN1wrapF1 builder
   */
  public static <A, R> ImmutableFN1wrapF1.Builder<A, R> builder() {
    return new ImmutableFN1wrapF1.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN1wrapF1 ImmutableFN1wrapF1}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN1.FN1wrapF1", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable F1<A, R> delegate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN1wrapF1} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> from(FN1.FN1wrapF1<A, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      return this;
    }

    /**
     * Initializes the value for the {@link FN1.FN1wrapF1#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> delegate(F1<A, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN1wrapF1 ImmutableFN1wrapF1}.
     * @return An immutable instance of FN1wrapF1
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN1wrapF1<A, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN1wrapF1<>(null, delegate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      return "Cannot build FN1wrapF1, some of required attributes are not set " + attributes;
    }
  }
}
