package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FN1.FN1checkNull}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFN1checkNull.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableFN1checkNull.of()}.
 */
@Generated(from = "FN1.FN1checkNull", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFN1checkNull<A, R>
    extends FN1.FN1checkNull<A, R> {
  private final F1<A, R> delegate;
  private final String a;

  private ImmutableFN1checkNull(F1<A, R> delegate, String a) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.a = Objects.requireNonNull(a, "a");
  }

  private ImmutableFN1checkNull(
      ImmutableFN1checkNull<A, R> original,
      F1<A, R> delegate,
      String a) {
    this.delegate = delegate;
    this.a = a;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F1<A, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected String a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN1.FN1checkNull#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN1checkNull<A, R> withDelegate(F1<A, R> value) {
    if (this.delegate == value) return this;
    F1<A, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableFN1checkNull<>(this, newValue, this.a);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FN1.FN1checkNull#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFN1checkNull<A, R> withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableFN1checkNull<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFN1checkNull} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFN1checkNull<?, ?>
        && equalTo(0, (ImmutableFN1checkNull<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableFN1checkNull<?, ?> another) {
    return delegate.equals(another.delegate)
        && a.equals(another.a);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + a.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FN1checkNull} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FN1checkNull")
        .omitNullValues()
        .add("delegate", delegate)
        .add("a", a)
        .toString();
  }

  /**
   * Construct a new immutable {@code FN1checkNull} instance.
 * @param <A> generic parameter A
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param a The value for the {@code a} attribute
   * @return An immutable FN1checkNull instance
   */
  public static <A, R> ImmutableFN1checkNull<A, R> of(F1<A, R> delegate, String a) {
    return new ImmutableFN1checkNull<>(delegate, a);
  }

  /**
   * Creates an immutable copy of a {@link FN1.FN1checkNull} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable FN1checkNull instance
   */
  public static <A, R> ImmutableFN1checkNull<A, R> copyOf(FN1.FN1checkNull<A, R> instance) {
    if (instance instanceof ImmutableFN1checkNull<?, ?>) {
      return (ImmutableFN1checkNull<A, R>) instance;
    }
    return ImmutableFN1checkNull.<A, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFN1checkNull ImmutableFN1checkNull}.
   * <pre>
   * ImmutableFN1checkNull.&amp;lt;A, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F1&amp;lt;A, R&amp;gt;) // required {@link FN1.FN1checkNull#delegate() delegate}
   *    .a(String) // required {@link FN1.FN1checkNull#a() a}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <R> generic parameter R
   * @return A new ImmutableFN1checkNull builder
   */
  public static <A, R> ImmutableFN1checkNull.Builder<A, R> builder() {
    return new ImmutableFN1checkNull.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableFN1checkNull ImmutableFN1checkNull}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FN1.FN1checkNull", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_A = 0x2L;
    private long initBits = 0x3L;

    private @Nullable F1<A, R> delegate;
    private @Nullable String a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FN1checkNull} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> from(FN1.FN1checkNull<A, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link FN1.FN1checkNull#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> delegate(F1<A, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link FN1.FN1checkNull#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, R> a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFN1checkNull ImmutableFN1checkNull}.
     * @return An immutable instance of FN1checkNull
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFN1checkNull<A, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFN1checkNull<>(null, delegate, a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build FN1checkNull, some of required attributes are not set " + attributes;
    }
  }
}
