package de.flapdoodle.formula.calculate.functions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link F5.F5WithLabel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableF5WithLabel.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableF5WithLabel.of()}.
 */
@Generated(from = "F5.F5WithLabel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableF5WithLabel<A, B, C, D, E, R>
    extends F5.F5WithLabel<A, B, C, D, E, R> {
  private final F5<A, B, C, D, E, R> delegate;
  private final String label;

  private ImmutableF5WithLabel(F5<A, B, C, D, E, R> delegate, String label) {
    this.delegate = Objects.requireNonNull(delegate, "delegate");
    this.label = Objects.requireNonNull(label, "label");
  }

  private ImmutableF5WithLabel(
      ImmutableF5WithLabel<A, B, C, D, E, R> original,
      F5<A, B, C, D, E, R> delegate,
      String label) {
    this.delegate = delegate;
    this.label = label;
  }

  /**
   * @return The value of the {@code delegate} attribute
   */
  @Override
  protected F5<A, B, C, D, E, R> delegate() {
    return delegate;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  protected String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link F5.F5WithLabel#delegate() delegate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF5WithLabel<A, B, C, D, E, R> withDelegate(F5<A, B, C, D, E, R> value) {
    if (this.delegate == value) return this;
    F5<A, B, C, D, E, R> newValue = Objects.requireNonNull(value, "delegate");
    return new ImmutableF5WithLabel<>(this, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link F5.F5WithLabel#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableF5WithLabel<A, B, C, D, E, R> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableF5WithLabel<>(this, this.delegate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableF5WithLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableF5WithLabel<?, ?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableF5WithLabel<?, ?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableF5WithLabel<?, ?, ?, ?, ?, ?> another) {
    return delegate.equals(another.delegate)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code delegate}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delegate.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code F5WithLabel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("F5WithLabel")
        .omitNullValues()
        .add("delegate", delegate)
        .add("label", label)
        .toString();
  }

  /**
   * Construct a new immutable {@code F5WithLabel} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <E> generic parameter E
 * @param <R> generic parameter R
   * @param delegate The value for the {@code delegate} attribute
   * @param label The value for the {@code label} attribute
   * @return An immutable F5WithLabel instance
   */
  public static <A, B, C, D, E, R> ImmutableF5WithLabel<A, B, C, D, E, R> of(F5<A, B, C, D, E, R> delegate, String label) {
    return new ImmutableF5WithLabel<>(delegate, label);
  }

  /**
   * Creates an immutable copy of a {@link F5.F5WithLabel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <E> generic parameter E
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable F5WithLabel instance
   */
  public static <A, B, C, D, E, R> ImmutableF5WithLabel<A, B, C, D, E, R> copyOf(F5.F5WithLabel<A, B, C, D, E, R> instance) {
    if (instance instanceof ImmutableF5WithLabel<?, ?, ?, ?, ?, ?>) {
      return (ImmutableF5WithLabel<A, B, C, D, E, R>) instance;
    }
    return ImmutableF5WithLabel.<A, B, C, D, E, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableF5WithLabel ImmutableF5WithLabel}.
   * <pre>
   * ImmutableF5WithLabel.&amp;lt;A, B, C, D, E, R&amp;gt;builder()
   *    .delegate(de.flapdoodle.formula.calculate.functions.F5&amp;lt;A, B, C, D, E, R&amp;gt;) // required {@link F5.F5WithLabel#delegate() delegate}
   *    .label(String) // required {@link F5.F5WithLabel#label() label}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <E> generic parameter E
   * @param <R> generic parameter R
   * @return A new ImmutableF5WithLabel builder
   */
  public static <A, B, C, D, E, R> ImmutableF5WithLabel.Builder<A, B, C, D, E, R> builder() {
    return new ImmutableF5WithLabel.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableF5WithLabel ImmutableF5WithLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "F5.F5WithLabel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A, B, C, D, E, R> {
    private static final long INIT_BIT_DELEGATE = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable F5<A, B, C, D, E, R> delegate;
    private @Nullable String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code F5WithLabel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, E, R> from(F5.F5WithLabel<A, B, C, D, E, R> instance) {
      Objects.requireNonNull(instance, "instance");
      delegate(instance.delegate());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link F5.F5WithLabel#delegate() delegate} attribute.
     * @param delegate The value for delegate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, E, R> delegate(F5<A, B, C, D, E, R> delegate) {
      this.delegate = Objects.requireNonNull(delegate, "delegate");
      initBits &= ~INIT_BIT_DELEGATE;
      return this;
    }

    /**
     * Initializes the value for the {@link F5.F5WithLabel#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A, B, C, D, E, R> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableF5WithLabel ImmutableF5WithLabel}.
     * @return An immutable instance of F5WithLabel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableF5WithLabel<A, B, C, D, E, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableF5WithLabel<>(null, delegate, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELEGATE) != 0) attributes.add("delegate");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build F5WithLabel, some of required attributes are not set " + attributes;
    }
  }
}
