package de.flapdoodle.formula.calculate.functions;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link F1.F1Identity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableF1Identity.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableF1Identity.of()}.
 */
@Generated(from = "F1.F1Identity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableF1Identity<X> extends F1.F1Identity<X> {

  private ImmutableF1Identity() {}

  /**
   * This instance is equal to all instances of {@code ImmutableF1Identity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableF1Identity<?>
        && equalTo(0, (ImmutableF1Identity<?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableF1Identity<?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 598435797;
  }

  /**
   * Prints the immutable value {@code F1Identity}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "F1Identity{}";
  }

  @SuppressWarnings("raw")
  private static final ImmutableF1Identity INSTANCE = validate(new ImmutableF1Identity());

  /**
   * Returns the default immutable singleton value of {@code F1Identity}
   * @return An immutable instance of F1Identity
   */
  @SuppressWarnings("unchecked")
  public static <X> ImmutableF1Identity<X> of() {
    return (ImmutableF1Identity<X>) INSTANCE;
  }

  private static <X> ImmutableF1Identity<X> validate(ImmutableF1Identity<X> instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link F1.F1Identity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable F1Identity instance
   */
  public static <X> ImmutableF1Identity<X> copyOf(F1.F1Identity<X> instance) {
    if (instance instanceof ImmutableF1Identity<?>) {
      return (ImmutableF1Identity<X>) instance;
    }
    return ImmutableF1Identity.<X>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableF1Identity ImmutableF1Identity}.
   * <pre>
   * ImmutableF1Identity.&amp;lt;X&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <X> generic parameter X
   * @return A new ImmutableF1Identity builder
   */
  public static <X> ImmutableF1Identity.Builder<X> builder() {
    return new ImmutableF1Identity.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableF1Identity ImmutableF1Identity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "F1.F1Identity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<X> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code F1Identity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<X> from(F1.F1Identity<X> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableF1Identity ImmutableF1Identity}.
     * @return An immutable instance of F1Identity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableF1Identity<X> build() {
      return ImmutableF1Identity.<X>of();
    }
  }
}
