package de.flapdoodle.formula.calculate.calculations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.functions.FN5;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Merge5}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMerge5.of()}.
 */
@Generated(from = "Merge5", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMerge5<A, B, C, D, E, X>
    extends Merge5<A, B, C, D, E, X> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final ValueSource<C> c;
  private final ValueSource<D> d;
  private final ValueSource<E> e;
  private final FN5<A, B, C, D, E, X> transformation;

  private ImmutableMerge5(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      ValueSource<E> e,
      FN5<A, B, C, D, E, X> transformation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.d = Objects.requireNonNull(d, "d");
    this.e = Objects.requireNonNull(e, "e");
    this.transformation = Objects.requireNonNull(transformation, "transformation");
  }

  private ImmutableMerge5(
      ImmutableMerge5<A, B, C, D, E, X> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      ValueSource<E> e,
      FN5<A, B, C, D, E, X> transformation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
    this.e = e;
    this.transformation = transformation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected ValueSource<C> c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  protected ValueSource<D> d() {
    return d;
  }

  /**
   * @return The value of the {@code e} attribute
   */
  @Override
  protected ValueSource<E> e() {
    return e;
  }

  /**
   * @return The value of the {@code transformation} attribute
   */
  @Override
  protected FN5<A, B, C, D, E, X> transformation() {
    return transformation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge5<>(this, newValue, this.a, this.b, this.c, this.d, this.e, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableMerge5<>(this, this.destination, newValue, this.b, this.c, this.d, this.e, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableMerge5<>(this, this.destination, this.a, newValue, this.c, this.d, this.e, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withC(ValueSource<C> value) {
    if (this.c == value) return this;
    ValueSource<C> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableMerge5<>(this, this.destination, this.a, this.b, newValue, this.d, this.e, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#d() d} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withD(ValueSource<D> value) {
    if (this.d == value) return this;
    ValueSource<D> newValue = Objects.requireNonNull(value, "d");
    return new ImmutableMerge5<>(this, this.destination, this.a, this.b, this.c, newValue, this.e, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#e() e} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for e
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withE(ValueSource<E> value) {
    if (this.e == value) return this;
    ValueSource<E> newValue = Objects.requireNonNull(value, "e");
    return new ImmutableMerge5<>(this, this.destination, this.a, this.b, this.c, this.d, newValue, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge5#transformation() transformation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transformation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge5<A, B, C, D, E, X> withTransformation(FN5<A, B, C, D, E, X> value) {
    if (this.transformation == value) return this;
    FN5<A, B, C, D, E, X> newValue = Objects.requireNonNull(value, "transformation");
    return new ImmutableMerge5<>(this, this.destination, this.a, this.b, this.c, this.d, this.e, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge5} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge5<?, ?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableMerge5<?, ?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMerge5<?, ?, ?, ?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d)
        && e.equals(another.e)
        && transformation.equals(another.transformation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code c}, {@code d}, {@code e}, {@code transformation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    h += (h << 5) + e.hashCode();
    h += (h << 5) + transformation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge5} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Merge5")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .add("e", e)
        .add("transformation", transformation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Merge5} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <E> generic parameter E
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param d The value for the {@code d} attribute
   * @param e The value for the {@code e} attribute
   * @param transformation The value for the {@code transformation} attribute
   * @return An immutable Merge5 instance
   */
  public static <A, B, C, D, E, X> ImmutableMerge5<A, B, C, D, E, X> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, ValueSource<D> d, ValueSource<E> e, FN5<A, B, C, D, E, X> transformation) {
    return new ImmutableMerge5<>(destination, a, b, c, d, e, transformation);
  }

  /**
   * Creates an immutable copy of a {@link Merge5} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <E> generic parameter E
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Merge5 instance
   */
  public static <A, B, C, D, E, X> ImmutableMerge5<A, B, C, D, E, X> copyOf(Merge5<A, B, C, D, E, X> instance) {
    if (instance instanceof ImmutableMerge5<?, ?, ?, ?, ?, ?>) {
      return (ImmutableMerge5<A, B, C, D, E, X>) instance;
    }
    return ImmutableMerge5.<A, B, C, D, E, X>of(instance.destination(), instance.a(), instance.b(), instance.c(), instance.d(), instance.e(), instance.transformation());
  }
}
