package de.flapdoodle.formula.calculate.calculations;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.functions.FN4;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Merge4}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMerge4.of()}.
 */
@Generated(from = "Merge4", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMerge4<A, B, C, D, X>
    extends Merge4<A, B, C, D, X> {
  private final Value<X> destination;
  private final ValueSource<A> a;
  private final ValueSource<B> b;
  private final ValueSource<C> c;
  private final ValueSource<D> d;
  private final FN4<A, B, C, D, X> transformation;

  private ImmutableMerge4(
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      FN4<A, B, C, D, X> transformation) {
    this.destination = Objects.requireNonNull(destination, "destination");
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.d = Objects.requireNonNull(d, "d");
    this.transformation = Objects.requireNonNull(transformation, "transformation");
  }

  private ImmutableMerge4(
      ImmutableMerge4<A, B, C, D, X> original,
      Value<X> destination,
      ValueSource<A> a,
      ValueSource<B> b,
      ValueSource<C> c,
      ValueSource<D> d,
      FN4<A, B, C, D, X> transformation) {
    this.destination = destination;
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
    this.transformation = transformation;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public Value<X> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  protected ValueSource<A> a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  protected ValueSource<B> b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  protected ValueSource<C> c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  protected ValueSource<D> d() {
    return d;
  }

  /**
   * @return The value of the {@code transformation} attribute
   */
  @Override
  protected FN4<A, B, C, D, X> transformation() {
    return transformation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withDestination(Value<X> value) {
    if (this.destination == value) return this;
    Value<X> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge4<>(this, newValue, this.a, this.b, this.c, this.d, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withA(ValueSource<A> value) {
    if (this.a == value) return this;
    ValueSource<A> newValue = Objects.requireNonNull(value, "a");
    return new ImmutableMerge4<>(this, this.destination, newValue, this.b, this.c, this.d, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withB(ValueSource<B> value) {
    if (this.b == value) return this;
    ValueSource<B> newValue = Objects.requireNonNull(value, "b");
    return new ImmutableMerge4<>(this, this.destination, this.a, newValue, this.c, this.d, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withC(ValueSource<C> value) {
    if (this.c == value) return this;
    ValueSource<C> newValue = Objects.requireNonNull(value, "c");
    return new ImmutableMerge4<>(this, this.destination, this.a, this.b, newValue, this.d, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#d() d} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withD(ValueSource<D> value) {
    if (this.d == value) return this;
    ValueSource<D> newValue = Objects.requireNonNull(value, "d");
    return new ImmutableMerge4<>(this, this.destination, this.a, this.b, this.c, newValue, this.transformation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge4#transformation() transformation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transformation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge4<A, B, C, D, X> withTransformation(FN4<A, B, C, D, X> value) {
    if (this.transformation == value) return this;
    FN4<A, B, C, D, X> newValue = Objects.requireNonNull(value, "transformation");
    return new ImmutableMerge4<>(this, this.destination, this.a, this.b, this.c, this.d, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge4} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge4<?, ?, ?, ?, ?>
        && equalTo(0, (ImmutableMerge4<?, ?, ?, ?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMerge4<?, ?, ?, ?, ?> another) {
    return destination.equals(another.destination)
        && a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d)
        && transformation.equals(another.transformation);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code a}, {@code b}, {@code c}, {@code d}, {@code transformation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    h += (h << 5) + transformation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge4} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Merge4")
        .omitNullValues()
        .add("destination", destination)
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .add("d", d)
        .add("transformation", transformation)
        .toString();
  }

  /**
   * Construct a new immutable {@code Merge4} instance.
 * @param <A> generic parameter A
 * @param <B> generic parameter B
 * @param <C> generic parameter C
 * @param <D> generic parameter D
 * @param <X> generic parameter X
   * @param destination The value for the {@code destination} attribute
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param d The value for the {@code d} attribute
   * @param transformation The value for the {@code transformation} attribute
   * @return An immutable Merge4 instance
   */
  public static <A, B, C, D, X> ImmutableMerge4<A, B, C, D, X> of(Value<X> destination, ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, ValueSource<D> d, FN4<A, B, C, D, X> transformation) {
    return new ImmutableMerge4<>(destination, a, b, c, d, transformation);
  }

  /**
   * Creates an immutable copy of a {@link Merge4} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param <B> generic parameter B
   * @param <C> generic parameter C
   * @param <D> generic parameter D
   * @param <X> generic parameter X
   * @param instance The instance to copy
   * @return A copied immutable Merge4 instance
   */
  public static <A, B, C, D, X> ImmutableMerge4<A, B, C, D, X> copyOf(Merge4<A, B, C, D, X> instance) {
    if (instance instanceof ImmutableMerge4<?, ?, ?, ?, ?>) {
      return (ImmutableMerge4<A, B, C, D, X>) instance;
    }
    return ImmutableMerge4.<A, B, C, D, X>of(instance.destination(), instance.a(), instance.b(), instance.c(), instance.d(), instance.transformation());
  }
}
