package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import de.flapdoodle.formula.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MappedValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMappedValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMappedValue.of()}.
 */
@Generated(from = "MappedValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMappedValue<T> implements MappedValue<T> {
  private final Value<T> id;
  private final @Nullable T value;

  private ImmutableMappedValue(Value<T> id, @Nullable T value) {
    this.id = Objects.requireNonNull(id, "id");
    this.value = value;
  }

  private ImmutableMappedValue(
      ImmutableMappedValue<T> original,
      Value<T> id,
      @Nullable T value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Value<T> id() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable T value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MappedValue#id() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedValue<T> withId(Value<T> value) {
    if (this.id == value) return this;
    Value<T> newValue = Objects.requireNonNull(value, "id");
    return new ImmutableMappedValue<>(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MappedValue#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedValue<T> withValue(@Nullable T value) {
    if (this.value == value) return this;
    return new ImmutableMappedValue<>(this, this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMappedValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMappedValue<?>
        && equalTo(0, (ImmutableMappedValue<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableMappedValue<?> another) {
    return id.equals(another.id)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code MappedValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MappedValue")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code MappedValue} instance.
 * @param <T> generic parameter T
   * @param id The value for the {@code id} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable MappedValue instance
   */
  public static <T> ImmutableMappedValue<T> of(Value<T> id, @Nullable T value) {
    return new ImmutableMappedValue<>(id, value);
  }

  /**
   * Creates an immutable copy of a {@link MappedValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable MappedValue instance
   */
  public static <T> ImmutableMappedValue<T> copyOf(MappedValue<T> instance) {
    if (instance instanceof ImmutableMappedValue<?>) {
      return (ImmutableMappedValue<T>) instance;
    }
    return ImmutableMappedValue.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMappedValue ImmutableMappedValue}.
   * <pre>
   * ImmutableMappedValue.&amp;lt;T&amp;gt;builder()
   *    .id(de.flapdoodle.formula.Value&amp;lt;T&amp;gt;) // required {@link MappedValue#id() id}
   *    .value(T | null) // nullable {@link MappedValue#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableMappedValue builder
   */
  public static <T> ImmutableMappedValue.Builder<T> builder() {
    return new ImmutableMappedValue.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMappedValue ImmutableMappedValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MappedValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Value<T> id;
    private @Nullable T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MappedValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(MappedValue<T> instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      @Nullable T valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MappedValue#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> id(Value<T> id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MappedValue#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(@Nullable T value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMappedValue ImmutableMappedValue}.
     * @return An immutable instance of MappedValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMappedValue<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMappedValue<>(null, id, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build MappedValue, some of required attributes are not set " + attributes;
    }
  }
}
