package de.flapdoodle.formula;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueContainer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueContainer.builder()}.
 */
@Generated(from = "ValueContainer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueContainer extends ValueContainer {
  private final ImmutableMap<Value<?>, Object> values;
  private final ImmutableSet<Value<?>> nullValues;

  private ImmutableValueContainer(
      ImmutableMap<Value<?>, Object> values,
      ImmutableSet<Value<?>> nullValues) {
    this.values = values;
    this.nullValues = nullValues;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  protected ImmutableMap<Value<?>, Object> values() {
    return values;
  }

  /**
   * @return The value of the {@code nullValues} attribute
   */
  @Override
  protected ImmutableSet<Value<?>> nullValues() {
    return nullValues;
  }

  /**
   * Copy the current immutable object by replacing the {@link ValueContainer#values() values} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the values map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueContainer withValues(Map<? extends Value<?>, ? extends Object> entries) {
    if (this.values == entries) return this;
    ImmutableMap<Value<?>, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableValueContainer(newValue, this.nullValues);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueContainer#nullValues() nullValues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableValueContainer withNullValues(Value<?>... elements) {
    ImmutableSet<Value<?>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableValueContainer(this.values, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueContainer#nullValues() nullValues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nullValues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueContainer withNullValues(Iterable<? extends Value<?>> elements) {
    if (this.nullValues == elements) return this;
    ImmutableSet<Value<?>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableValueContainer(this.values, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueContainer
        && equalTo(0, (ImmutableValueContainer) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueContainer another) {
    return values.equals(another.values)
        && nullValues.equals(another.nullValues);
  }

  /**
   * Computes a hash code from attributes: {@code values}, {@code nullValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + values.hashCode();
    h += (h << 5) + nullValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueContainer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueContainer")
        .omitNullValues()
        .add("values", values)
        .add("nullValues", nullValues)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ValueContainer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueContainer instance
   */
  public static ImmutableValueContainer copyOf(ValueContainer instance) {
    if (instance instanceof ImmutableValueContainer) {
      return (ImmutableValueContainer) instance;
    }
    return ImmutableValueContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueContainer ImmutableValueContainer}.
   * <pre>
   * ImmutableValueContainer.builder()
   *    .putValues|putAllValues(de.flapdoodle.formula.Value&amp;lt;?&amp;gt; =&gt; Object) // {@link ValueContainer#values() values} mappings
   *    .addNullValues|addAllNullValues(de.flapdoodle.formula.Value&amp;lt;?&amp;gt;) // {@link ValueContainer#nullValues() nullValues} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValueContainer builder
   */
  public static ImmutableValueContainer.Builder builder() {
    return new ImmutableValueContainer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueContainer ImmutableValueContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueContainer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<Value<?>, Object> values = ImmutableMap.builder();
    private ImmutableSet.Builder<Value<?>> nullValues = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueContainer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueContainer instance) {
      Objects.requireNonNull(instance, "instance");
      putAllValues(instance.values());
      addAllNullValues(instance.nullValues());
      return this;
    }

    /**
     * Put one entry to the {@link ValueContainer#values() values} map.
     * @param key The key in the values map
     * @param value The associated value in the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(Value<?> key, Object value) {
      this.values.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ValueContainer#values() values} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(Map.Entry<? extends Value<?>, ? extends Object> entry) {
      this.values.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ValueContainer#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Map<? extends Value<?>, ? extends Object> entries) {
      this.values = ImmutableMap.builder();
      return putAllValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ValueContainer#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValues(Map<? extends Value<?>, ? extends Object> entries) {
      this.values.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link ValueContainer#nullValues() nullValues} set.
     * @param element A nullValues element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNullValues(Value<?> element) {
      this.nullValues.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValueContainer#nullValues() nullValues} set.
     * @param elements An array of nullValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addNullValues(Value<?>... elements) {
      this.nullValues.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValueContainer#nullValues() nullValues} set.
     * @param elements An iterable of nullValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullValues(Iterable<? extends Value<?>> elements) {
      this.nullValues = ImmutableSet.builder();
      return addAllNullValues(elements);
    }

    /**
     * Adds elements to {@link ValueContainer#nullValues() nullValues} set.
     * @param elements An iterable of nullValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNullValues(Iterable<? extends Value<?>> elements) {
      this.nullValues.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueContainer ImmutableValueContainer}.
     * @return An immutable instance of ValueContainer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueContainer build() {
      return new ImmutableValueContainer(values.build(), nullValues.build());
    }
  }
}
