package de.flapdoodle.formula;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Unvalidated}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUnvalidated.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUnvalidated.of()}.
 */
@Generated(from = "Unvalidated", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUnvalidated<T> implements Unvalidated<T> {
  private final ValueSource<T> wrapped;

  private ImmutableUnvalidated(ValueSource<T> wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableUnvalidated(ImmutableUnvalidated<T> original, ValueSource<T> wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public ValueSource<T> wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Unvalidated#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUnvalidated<T> withWrapped(ValueSource<T> value) {
    if (this.wrapped == value) return this;
    ValueSource<T> newValue = Objects.requireNonNull(value, "wrapped");
    return new ImmutableUnvalidated<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUnvalidated} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUnvalidated<?>
        && equalTo(0, (ImmutableUnvalidated<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableUnvalidated<?> another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Unvalidated} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Unvalidated")
        .omitNullValues()
        .add("wrapped", wrapped)
        .toString();
  }

  /**
   * Construct a new immutable {@code Unvalidated} instance.
 * @param <T> generic parameter T
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable Unvalidated instance
   */
  public static <T> ImmutableUnvalidated<T> of(ValueSource<T> wrapped) {
    return new ImmutableUnvalidated<>(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Unvalidated} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Unvalidated instance
   */
  public static <T> ImmutableUnvalidated<T> copyOf(Unvalidated<T> instance) {
    if (instance instanceof ImmutableUnvalidated<?>) {
      return (ImmutableUnvalidated<T>) instance;
    }
    return ImmutableUnvalidated.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUnvalidated ImmutableUnvalidated}.
   * <pre>
   * ImmutableUnvalidated.&amp;lt;T&amp;gt;builder()
   *    .wrapped(de.flapdoodle.formula.ValueSource&amp;lt;T&amp;gt;) // required {@link Unvalidated#wrapped() wrapped}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableUnvalidated builder
   */
  public static <T> ImmutableUnvalidated.Builder<T> builder() {
    return new ImmutableUnvalidated.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableUnvalidated ImmutableUnvalidated}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Unvalidated", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ValueSource<T> wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Unvalidated} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Unvalidated<T> instance) {
      Objects.requireNonNull(instance, "instance");
      wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Unvalidated#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> wrapped(ValueSource<T> wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUnvalidated ImmutableUnvalidated}.
     * @return An immutable instance of Unvalidated
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUnvalidated<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUnvalidated<>(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build Unvalidated, some of required attributes are not set " + attributes;
    }
  }
}
