/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values.domain;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.types.Id;
import de.flapdoodle.formula.values.domain.ReadOnlyValue;
import de.flapdoodle.formula.values.properties.ReadOnlyProperty;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReadOnlyValue", generator="Immutables")
@Immutable
public final class ImmutableReadOnlyValue<O, T>
extends ReadOnlyValue<O, T> {
    private final Id<O> id;
    private final ReadOnlyProperty<O, T> property;

    private ImmutableReadOnlyValue(Id<O> id, ReadOnlyProperty<O, T> property) {
        this.id = Objects.requireNonNull(id, "id");
        this.property = Objects.requireNonNull(property, "property");
    }

    private ImmutableReadOnlyValue(ImmutableReadOnlyValue<O, T> original, Id<O> id, ReadOnlyProperty<O, T> property) {
        this.id = id;
        this.property = property;
    }

    @Override
    public Id<O> id() {
        return this.id;
    }

    @Override
    protected ReadOnlyProperty<O, T> property() {
        return this.property;
    }

    public final ImmutableReadOnlyValue<O, T> withId(Id<O> value) {
        if (this.id == value) {
            return this;
        }
        Id<O> newValue = Objects.requireNonNull(value, "id");
        return new ImmutableReadOnlyValue<O, T>(this, newValue, this.property);
    }

    public final ImmutableReadOnlyValue<O, T> withProperty(ReadOnlyProperty<O, T> value) {
        if (this.property == value) {
            return this;
        }
        ReadOnlyProperty<O, T> newValue = Objects.requireNonNull(value, "property");
        return new ImmutableReadOnlyValue<O, T>(this, this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadOnlyValue && this.equalTo(0, (ImmutableReadOnlyValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadOnlyValue<?, ?> another) {
        return this.id.equals(another.id) && this.property.equals(another.property);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.property.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReadOnlyValue").omitNullValues().add("id", this.id).add("property", this.property).toString();
    }

    public static <O, T> ImmutableReadOnlyValue<O, T> of(Id<O> id, ReadOnlyProperty<O, T> property) {
        return new ImmutableReadOnlyValue<O, T>(id, property);
    }

    public static <O, T> ImmutableReadOnlyValue<O, T> copyOf(ReadOnlyValue<O, T> instance) {
        if (instance instanceof ImmutableReadOnlyValue) {
            return (ImmutableReadOnlyValue)instance;
        }
        return ImmutableReadOnlyValue.builder().from(instance).build();
    }

    public static <O, T> Builder<O, T> builder() {
        return new Builder();
    }

    @Generated(from="ReadOnlyValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<O, T> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROPERTY = 2L;
        private long initBits = 3L;
        @Nullable
        private Id<O> id;
        @Nullable
        private ReadOnlyProperty<O, T> property;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> from(ReadOnlyValue<O, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.property(instance.property());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> id(Id<O> id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> property(ReadOnlyProperty<O, T> property) {
            this.property = Objects.requireNonNull(property, "property");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReadOnlyValue<O, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadOnlyValue(null, this.id, this.property);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("property");
            }
            return "Cannot build ReadOnlyValue, some of required attributes are not set " + attributes;
        }
    }
}

