/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.values.Related;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Related", generator="Immutables")
@Immutable
public final class ImmutableRelated<T, B>
extends Related<T, B> {
    private final Value<T> destination;
    private final B reference;

    private ImmutableRelated(Value<T> destination, B reference) {
        this.destination = Objects.requireNonNull(destination, "destination");
        this.reference = Objects.requireNonNull(reference, "reference");
    }

    private ImmutableRelated(ImmutableRelated<T, B> original, Value<T> destination, B reference) {
        this.destination = destination;
        this.reference = reference;
    }

    @Override
    protected Value<T> destination() {
        return this.destination;
    }

    @Override
    protected B reference() {
        return this.reference;
    }

    public final ImmutableRelated<T, B> withDestination(Value<T> value) {
        if (this.destination == value) {
            return this;
        }
        Value<T> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableRelated<T, B>(this, newValue, this.reference);
    }

    public final ImmutableRelated<T, B> withReference(B value) {
        if (this.reference == value) {
            return this;
        }
        B newValue = Objects.requireNonNull(value, "reference");
        return new ImmutableRelated<T, B>(this, this.destination, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelated && this.equalTo(0, (ImmutableRelated)another);
    }

    private boolean equalTo(int synthetic, ImmutableRelated<?, ?> another) {
        return this.destination.equals(another.destination) && this.reference.equals(another.reference);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.reference.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Related").omitNullValues().add("destination", this.destination).add("reference", this.reference).toString();
    }

    public static <T, B> ImmutableRelated<T, B> of(Value<T> destination, B reference) {
        return new ImmutableRelated<T, B>(destination, reference);
    }

    public static <T, B> ImmutableRelated<T, B> copyOf(Related<T, B> instance) {
        if (instance instanceof ImmutableRelated) {
            return (ImmutableRelated)instance;
        }
        return ImmutableRelated.builder().from(instance).build();
    }

    public static <T, B> Builder<T, B> builder() {
        return new Builder();
    }

    @Generated(from="Related", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T, B> {
        private static final long INIT_BIT_DESTINATION = 1L;
        private static final long INIT_BIT_REFERENCE = 2L;
        private long initBits = 3L;
        @Nullable
        private Value<T> destination;
        @Nullable
        private B reference;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T, B> from(Related<T, B> instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.destination());
            this.reference(instance.reference());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, B> destination(Value<T> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T, B> reference(B reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRelated<T, B> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelated(null, this.destination, this.reference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reference");
            }
            return "Cannot build Related, some of required attributes are not set " + attributes;
        }
    }
}

