/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values;

import com.google.common.base.MoreObjects;
import de.flapdoodle.formula.values.Named;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Named", generator="Immutables")
@Immutable
public final class ImmutableNamed<T>
extends Named<T> {
    @Nullable
    private final String name;
    private final Class<T> type;

    private ImmutableNamed(Optional<String> name, Class<T> type) {
        this.name = name.orElse(null);
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableNamed(ImmutableNamed<T> original, @Nullable String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    @Override
    protected Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    protected Class<T> type() {
        return this.type;
    }

    public final ImmutableNamed<T> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableNamed<T>(this, newValue, this.type);
    }

    public final ImmutableNamed<T> withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableNamed<T>(this, value, this.type);
    }

    public final ImmutableNamed<T> withType(Class<T> value) {
        if (this.type == value) {
            return this;
        }
        Class<T> newValue = Objects.requireNonNull(value, "type");
        return new ImmutableNamed<T>(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNamed && this.equalTo(0, (ImmutableNamed)another);
    }

    private boolean equalTo(int synthetic, ImmutableNamed<?> another) {
        return Objects.equals(this.name, another.name) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Named").omitNullValues().add("name", (Object)this.name).add("type", this.type).toString();
    }

    public static <T> ImmutableNamed<T> of(Optional<String> name, Class<T> type) {
        return new ImmutableNamed<T>(name, type);
    }

    public static <T> ImmutableNamed<T> copyOf(Named<T> instance) {
        if (instance instanceof ImmutableNamed) {
            return (ImmutableNamed)instance;
        }
        return ImmutableNamed.of(instance.name(), instance.type());
    }
}

