/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.values;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.values.Attribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Attribute", generator="Immutables")
@Immutable
public final class ImmutableAttribute<O, T>
extends Attribute<O, T> {
    private final Class<O> objectType;
    private final String name;
    private final Function<O, T> getter;
    private final BiConsumer<O, T> setter;

    private ImmutableAttribute(Class<O> objectType, String name, Function<O, T> getter, BiConsumer<O, T> setter) {
        this.objectType = objectType;
        this.name = name;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected Class<O> objectType() {
        return this.objectType;
    }

    @Override
    protected String name() {
        return this.name;
    }

    @Override
    protected Function<O, T> getter() {
        return this.getter;
    }

    @Override
    protected BiConsumer<O, T> setter() {
        return this.setter;
    }

    public final ImmutableAttribute<O, T> withObjectType(Class<O> value) {
        if (this.objectType == value) {
            return this;
        }
        Class<O> newValue = Objects.requireNonNull(value, "objectType");
        return new ImmutableAttribute<O, T>(newValue, this.name, this.getter, this.setter);
    }

    public final ImmutableAttribute<O, T> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAttribute<O, T>(this.objectType, newValue, this.getter, this.setter);
    }

    public final ImmutableAttribute<O, T> withGetter(Function<O, T> value) {
        if (this.getter == value) {
            return this;
        }
        Function<O, T> newValue = Objects.requireNonNull(value, "getter");
        return new ImmutableAttribute<O, T>(this.objectType, this.name, newValue, this.setter);
    }

    public final ImmutableAttribute<O, T> withSetter(BiConsumer<O, T> value) {
        if (this.setter == value) {
            return this;
        }
        BiConsumer<O, T> newValue = Objects.requireNonNull(value, "setter");
        return new ImmutableAttribute<O, T>(this.objectType, this.name, this.getter, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttribute && this.equalTo(0, (ImmutableAttribute)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttribute<?, ?> another) {
        return this.objectType.equals(another.objectType) && this.name.equals(another.name) && this.getter.equals(another.getter) && this.setter.equals(another.setter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.objectType.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.getter.hashCode();
        h += (h << 5) + this.setter.hashCode();
        return h;
    }

    public static <O, T> ImmutableAttribute<O, T> copyOf(Attribute<O, T> instance) {
        if (instance instanceof ImmutableAttribute) {
            return (ImmutableAttribute)instance;
        }
        return ImmutableAttribute.builder().from(instance).build();
    }

    public static <O, T> Builder<O, T> builder() {
        return new Builder();
    }

    @Generated(from="Attribute", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<O, T> {
        private static final long INIT_BIT_OBJECT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_GETTER = 4L;
        private static final long INIT_BIT_SETTER = 8L;
        private long initBits = 15L;
        @Nullable
        private Class<O> objectType;
        @Nullable
        private String name;
        @Nullable
        private Function<O, T> getter;
        @Nullable
        private BiConsumer<O, T> setter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> from(Attribute<O, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.objectType(instance.objectType());
            this.name(instance.name());
            this.getter(instance.getter());
            this.setter(instance.setter());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> objectType(Class<O> objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> getter(Function<O, T> getter) {
            this.getter = Objects.requireNonNull(getter, "getter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<O, T> setter(BiConsumer<O, T> setter) {
            this.setter = Objects.requireNonNull(setter, "setter");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAttribute<O, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttribute(this.objectType, this.name, this.getter, this.setter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("objectType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("getter");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("setter");
            }
            return "Cannot build Attribute, some of required attributes are not set " + attributes;
        }
    }
}

