/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.validation.Validation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ValidationMap {
    private final Map<Value<?>, Validation<?>> map;

    private ValidationMap(Map<Value<?>, Validation<?>> map) {
        this.map = map;
    }

    public Collection<Validation<?>> values() {
        return this.map.values();
    }

    public Set<Value<?>> keys() {
        return this.map.keySet();
    }

    public <T> Validation<T> get(Value<T> key) {
        return this.map.get(key);
    }

    public boolean contains(Value<?> it) {
        return this.map.containsKey(it);
    }

    public ValidationMap add(Validation<?> validation) {
        Preconditions.checkArgument((!this.map.containsKey(validation.destination()) ? 1 : 0) != 0, (String)"validation already set for %s", validation);
        return new ValidationMap((Map<Value<?>, Validation<?>>)ImmutableMap.builder().putAll(this.map).put(validation.destination(), validation).build());
    }

    public ValidationMap addAll(List<Validation<?>> validations) {
        ImmutableMap newCalculations = Maps.uniqueIndex(validations, Validation::destination);
        Sets.SetView duplicates = Sets.intersection((Set)newCalculations.keySet(), this.map.keySet());
        Preconditions.checkArgument((boolean)duplicates.isEmpty(), (String)"validation already set for %s", (Object)duplicates);
        return new ValidationMap((Map<Value<?>, Validation<?>>)ImmutableMap.builder().putAll(this.map).putAll((Map)newCalculations).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMap that = (ValidationMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static ValidationMap empty() {
        return new ValidationMap((Map<Value<?>, Validation<?>>)ImmutableMap.of());
    }
}

