/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.validation;

import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSink;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.validation.Validations;

public abstract class Validate {
    private Validate() {
    }

    public static <X> WithDestination<X> value(ValueSink<X> destination) {
        return new WithDestination(destination);
    }

    public static class WithRelationTo2<X, A, B> {
        private Value<X> destination;
        private ValueSource<A> a;
        private ValueSource<B> b;

        public WithRelationTo2(Value<X> destination, ValueSource<A> a, ValueSource<B> b) {
            this.destination = destination;
            this.a = a;
            this.b = b;
        }

        public Validations.RelatedTo2<X, A, B> by(Validations.V2<X, A, B> validator) {
            return Validations.RelatedTo2.with(this.destination, this.a, this.b, validator);
        }
    }

    public static class WithRelationTo1<X, A> {
        private Value<X> destination;
        private ValueSource<A> a;

        public WithRelationTo1(Value<X> destination, ValueSource<A> a) {
            this.destination = destination;
            this.a = a;
        }

        public Validations.RelatedTo1<X, A> by(Validations.V1<X, A> validator) {
            return Validations.RelatedTo1.with(this.destination, this.a, validator);
        }
    }

    public static class WithDestination<X> {
        private final ValueSink<X> destination;

        private WithDestination(ValueSink<X> destination) {
            this.destination = destination;
        }

        public Validations.Self<X> by(Validations.V0<X> validator) {
            return Validations.Self.with(this.destination, validator);
        }

        public <A> WithRelationTo1<X, A> using(ValueSource<A> a) {
            return new WithRelationTo1<X, A>(this.destination, a);
        }

        public <A, B> WithRelationTo2<X, A, B> using(ValueSource<A> a, ValueSource<B> b) {
            return new WithRelationTo2<X, A, B>(this.destination, a, b);
        }
    }
}

