/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.validation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.validation.ValidatedValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValidatedValue", generator="Immutables")
@Immutable
public final class ImmutableValidatedValue<T>
extends ValidatedValue<T> {
    private final ValueSource<T> source;
    @Nullable
    private final T value;
    private final ImmutableSet<ValueSource<?>> invalidReferences;

    private ImmutableValidatedValue(ValueSource<T> source, @Nullable T value, ImmutableSet<ValueSource<?>> invalidReferences) {
        this.source = source;
        this.value = value;
        this.invalidReferences = invalidReferences;
    }

    @Override
    public ValueSource<T> source() {
        return this.source;
    }

    @Override
    public Optional<T> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public ImmutableSet<ValueSource<?>> invalidReferences() {
        return this.invalidReferences;
    }

    public final ImmutableValidatedValue<T> withSource(ValueSource<T> value) {
        if (this.source == value) {
            return this;
        }
        ValueSource<T> newValue = Objects.requireNonNull(value, "source");
        return new ImmutableValidatedValue<T>(newValue, this.value, this.invalidReferences);
    }

    public final ImmutableValidatedValue<T> withValue(T value) {
        T newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return new ImmutableValidatedValue<T>(this.source, newValue, this.invalidReferences);
    }

    public final ImmutableValidatedValue<T> withValue(Optional<? extends T> optional) {
        T value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return new ImmutableValidatedValue<Object>((ValueSource<Object>)this.source, value, this.invalidReferences);
    }

    @SafeVarargs
    public final ImmutableValidatedValue<T> withInvalidReferences(ValueSource<?> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableValidatedValue<T>(this.source, this.value, newValue);
    }

    public final ImmutableValidatedValue<T> withInvalidReferences(Iterable<? extends ValueSource<?>> elements) {
        if (this.invalidReferences == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableValidatedValue<T>(this.source, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidatedValue && this.equalTo(0, (ImmutableValidatedValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidatedValue<?> another) {
        return this.source.equals(another.source) && Objects.equals(this.value, another.value) && this.invalidReferences.equals(another.invalidReferences);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.invalidReferences.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValidatedValue").omitNullValues().add("source", this.source).add("value", this.value).add("invalidReferences", this.invalidReferences).toString();
    }

    public static <T> ImmutableValidatedValue<T> copyOf(ValidatedValue<T> instance) {
        if (instance instanceof ImmutableValidatedValue) {
            return (ImmutableValidatedValue)instance;
        }
        return ImmutableValidatedValue.builder().from(instance).build();
    }

    public static <T> Builder<T> builder(ValueSource<T> source) {
        return new Builder(source);
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ValidatedValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_SOURCE = 1L;
        private long initBits = 1L;
        @Nullable
        private ValueSource<T> source;
        @Nullable
        private T value;
        private ImmutableSet.Builder<ValueSource<?>> invalidReferences = ImmutableSet.builder();

        private Builder(ValueSource<T> source) {
            this.source(source);
        }

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ValidatedValue<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.source());
            Optional<T> valueOptional = instance.value();
            if (valueOptional.isPresent()) {
                this.value(valueOptional);
            }
            this.addAllInvalidReferences(instance.invalidReferences());
            return this;
        }

        @CanIgnoreReturnValue
        final Builder<T> source(ValueSource<T> source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(Optional<? extends T> value) {
            this.value = value.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addInvalidReferences(ValueSource<?> element) {
            this.invalidReferences.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<T> addInvalidReferences(ValueSource<?> ... elements) {
            this.invalidReferences.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> invalidReferences(Iterable<? extends ValueSource<?>> elements) {
            this.invalidReferences = ImmutableSet.builder();
            return this.addAllInvalidReferences(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllInvalidReferences(Iterable<? extends ValueSource<?>> elements) {
            this.invalidReferences.addAll(elements);
            return this;
        }

        public ImmutableValidatedValue<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidatedValue(this.source, this.value, this.invalidReferences.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build ValidatedValue, some of required attributes are not set " + attributes;
        }
    }
}

