/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.flapdoodle.formula.Rules;
import de.flapdoodle.formula.Unvalidated;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.calculate.CalculationMap;
import de.flapdoodle.formula.solver.ValueGraph;
import de.flapdoodle.formula.validation.Validation;
import de.flapdoodle.formula.validation.ValidationMap;
import de.flapdoodle.graph.Graphs;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public abstract class ValueDependencyGraphBuilder {
    private ValueDependencyGraphBuilder() {
    }

    public static ValueGraph build(Rules rules) {
        DefaultDirectedGraph<Value<?>, DefaultEdge> graph = ValueDependencyGraphBuilder.buildGraph(rules.calculations(), rules.validations());
        return new ValueGraph(graph, rules.calculations(), rules.validations());
    }

    private static DefaultDirectedGraph<Value<?>, DefaultEdge> buildGraph(CalculationMap calculations, ValidationMap validations) {
        Wrapper builder = new Wrapper();
        Set allSources = (Set)Stream.concat(calculations.values().stream().flatMap(it -> it.sources().stream()), validations.values().stream().flatMap(it -> it.sources().stream())).collect(ImmutableSet.toImmutableSet());
        ImmutableSet validatedOrCalculated = ImmutableSet.builder().addAll(calculations.keys()).addAll(validations.keys()).build();
        Sets.SetView unvalidatedOrCalculated = Sets.difference((Set)allSources, (Set)validatedOrCalculated);
        unvalidatedOrCalculated.forEach(it -> {
            if (!(it instanceof Unvalidated)) {
                builder.add((Value<?>)it, null, null);
            }
        });
        calculations.values().forEach(calculation -> builder.add(calculation.destination(), (Calculation<?>)calculation, validations.get(calculation.destination())));
        validations.values().forEach(validation -> {
            if (!calculations.contains(validation.destination())) {
                builder.add(validation.destination(), null, (Validation<?>)validation);
            }
        });
        return builder.build();
    }

    private static class Wrapper {
        private final Graphs.GraphBuilder<Value<?>, DefaultEdge, DefaultDirectedGraph<Value<?>, DefaultEdge>> builder = (Graphs.GraphBuilder)Graphs.graphBuilder((Supplier)Graphs.directedGraph()).get();

        private Wrapper() {
        }

        Wrapper add(Value<?> destination, @Nullable Calculation<?> calculation, @Nullable Validation<?> validation) {
            List calcSources = Optional.ofNullable(calculation).map(c -> c.sources().stream().map(it -> {
                Preconditions.checkArgument((!(it instanceof Unvalidated) ? 1 : 0) != 0, (String)"not allowed in calculation: %s", (Object)it);
                return it;
            }).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            List validationSources = Optional.ofNullable(validation).map(Validation::sources).orElse((List)ImmutableList.of());
            ImmutableList allSources = ImmutableList.builder().addAll((Iterable)calcSources).addAll((Iterable)validationSources).build();
            this.builder.addVertex(destination);
            allSources.forEach(it -> {
                this.builder.addVertex(it);
                this.builder.addEdge(it, (Object)destination);
            });
            return this;
        }

        public DefaultDirectedGraph<Value<?>, DefaultEdge> build() {
            return (DefaultDirectedGraph)this.builder.build();
        }
    }
}

