/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.solver.Context;
import de.flapdoodle.formula.solver.ValueContainer;
import de.flapdoodle.formula.validation.ErrorMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Context", generator="Immutables")
@Immutable
public final class ImmutableContext
extends Context {
    private final ValueContainer values;
    private final ValueContainer validatedValues;
    private final ImmutableSet<Value<?>> validatedValuesWithErrors;
    private final ImmutableMap<Value<?>, List<ErrorMessage>> errorMessages;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableContext(Builder builder) {
        this.validatedValuesWithErrors = builder.validatedValuesWithErrors.build();
        this.errorMessages = builder.errorMessages.build();
        if (builder.values != null) {
            this.initShim.values(builder.values);
        }
        if (builder.validatedValues != null) {
            this.initShim.validatedValues(builder.validatedValues);
        }
        this.values = this.initShim.values();
        this.validatedValues = this.initShim.validatedValues();
        this.initShim = null;
    }

    private ImmutableContext(ValueContainer values, ValueContainer validatedValues, ImmutableSet<Value<?>> validatedValuesWithErrors, ImmutableMap<Value<?>, List<ErrorMessage>> errorMessages) {
        this.values = values;
        this.validatedValues = validatedValues;
        this.validatedValuesWithErrors = validatedValuesWithErrors;
        this.errorMessages = errorMessages;
        this.initShim = null;
    }

    @Override
    protected ValueContainer values() {
        InitShim shim = this.initShim;
        return shim != null ? shim.values() : this.values;
    }

    @Override
    protected ValueContainer validatedValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validatedValues() : this.validatedValues;
    }

    protected ImmutableSet<Value<?>> validatedValuesWithErrors() {
        return this.validatedValuesWithErrors;
    }

    protected ImmutableMap<Value<?>, List<ErrorMessage>> errorMessages() {
        return this.errorMessages;
    }

    public final ImmutableContext withValues(ValueContainer value) {
        if (this.values == value) {
            return this;
        }
        ValueContainer newValue = Objects.requireNonNull(value, "values");
        return new ImmutableContext(newValue, this.validatedValues, this.validatedValuesWithErrors, this.errorMessages);
    }

    public final ImmutableContext withValidatedValues(ValueContainer value) {
        if (this.validatedValues == value) {
            return this;
        }
        ValueContainer newValue = Objects.requireNonNull(value, "validatedValues");
        return new ImmutableContext(this.values, newValue, this.validatedValuesWithErrors, this.errorMessages);
    }

    @SafeVarargs
    public final ImmutableContext withValidatedValuesWithErrors(Value<?> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableContext(this.values, this.validatedValues, newValue, this.errorMessages);
    }

    public final ImmutableContext withValidatedValuesWithErrors(Iterable<? extends Value<?>> elements) {
        if (this.validatedValuesWithErrors == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableContext(this.values, this.validatedValues, newValue, this.errorMessages);
    }

    public final ImmutableContext withErrorMessages(Map<? extends Value<?>, ? extends List<ErrorMessage>> entries) {
        if (this.errorMessages == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableContext(this.values, this.validatedValues, this.validatedValuesWithErrors, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContext && this.equalTo(0, (ImmutableContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableContext another) {
        return this.values.equals(another.values) && this.validatedValues.equals(another.validatedValues) && this.validatedValuesWithErrors.equals(another.validatedValuesWithErrors) && this.errorMessages.equals(another.errorMessages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.validatedValues.hashCode();
        h += (h << 5) + this.validatedValuesWithErrors.hashCode();
        h += (h << 5) + this.errorMessages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Context").omitNullValues().add("values", (Object)this.values).add("validatedValues", (Object)this.validatedValues).add("validatedValuesWithErrors", this.validatedValuesWithErrors).add("errorMessages", this.errorMessages).toString();
    }

    public static ImmutableContext copyOf(Context instance) {
        if (instance instanceof ImmutableContext) {
            return (ImmutableContext)instance;
        }
        return ImmutableContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Context", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private ValueContainer values;
        @Nullable
        private ValueContainer validatedValues;
        private ImmutableSet.Builder<Value<?>> validatedValuesWithErrors = ImmutableSet.builder();
        private ImmutableMap.Builder<Value<?>, List<ErrorMessage>> errorMessages = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Context instance) {
            Objects.requireNonNull(instance, "instance");
            this.values(instance.values());
            this.validatedValues(instance.validatedValues());
            this.addAllValidatedValuesWithErrors(instance.validatedValuesWithErrors());
            this.putAllErrorMessages(instance.errorMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(ValueContainer values) {
            this.values = Objects.requireNonNull(values, "values");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatedValues(ValueContainer validatedValues) {
            this.validatedValues = Objects.requireNonNull(validatedValues, "validatedValues");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValidatedValuesWithErrors(Value<?> element) {
            this.validatedValuesWithErrors.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addValidatedValuesWithErrors(Value<?> ... elements) {
            this.validatedValuesWithErrors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatedValuesWithErrors(Iterable<? extends Value<?>> elements) {
            this.validatedValuesWithErrors = ImmutableSet.builder();
            return this.addAllValidatedValuesWithErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValidatedValuesWithErrors(Iterable<? extends Value<?>> elements) {
            this.validatedValuesWithErrors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrorMessages(Value<?> key, List<ErrorMessage> value) {
            this.errorMessages.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrorMessages(Map.Entry<? extends Value<?>, ? extends List<ErrorMessage>> entry) {
            this.errorMessages.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessages(Map<? extends Value<?>, ? extends List<ErrorMessage>> entries) {
            this.errorMessages = ImmutableMap.builder();
            return this.putAllErrorMessages(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllErrorMessages(Map<? extends Value<?>, ? extends List<ErrorMessage>> entries) {
            this.errorMessages.putAll(entries);
            return this;
        }

        public ImmutableContext build() {
            return new ImmutableContext(this);
        }
    }

    @Generated(from="Context", generator="Immutables")
    private final class InitShim {
        private byte valuesBuildStage = 0;
        private ValueContainer values;
        private byte validatedValuesBuildStage = 0;
        private ValueContainer validatedValues;

        private InitShim() {
        }

        ValueContainer values() {
            if (this.valuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valuesBuildStage == 0) {
                this.valuesBuildStage = (byte)-1;
                this.values = Objects.requireNonNull(ImmutableContext.super.values(), "values");
                this.valuesBuildStage = 1;
            }
            return this.values;
        }

        void values(ValueContainer values) {
            this.values = values;
            this.valuesBuildStage = 1;
        }

        ValueContainer validatedValues() {
            if (this.validatedValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatedValuesBuildStage == 0) {
                this.validatedValuesBuildStage = (byte)-1;
                this.validatedValues = Objects.requireNonNull(ImmutableContext.super.validatedValues(), "validatedValues");
                this.validatedValuesBuildStage = 1;
            }
            return this.validatedValues;
        }

        void validatedValues(ValueContainer validatedValues) {
            this.validatedValues = validatedValues;
            this.validatedValuesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.valuesBuildStage == -1) {
                attributes.add("values");
            }
            if (this.validatedValuesBuildStage == -1) {
                attributes.add("validatedValues");
            }
            return "Cannot build Context, attribute initializers form cycle " + attributes;
        }
    }
}

