/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.collect.ImmutableMap;
import de.flapdoodle.formula.Unvalidated;
import de.flapdoodle.formula.Value;
import de.flapdoodle.graph.GraphAsDot;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public abstract class GraphRenderer {
    private GraphRenderer() {
    }

    public static String renderGraphAsDot(DefaultDirectedGraph<Value<?>, DefaultEdge> graph) {
        return GraphRenderer.renderGraphAsDot(graph, it -> {
            if (it instanceof Unvalidated) {
                return ((Unvalidated)it).wrapped().toString();
            }
            return it.toString();
        });
    }

    public static String renderGraphAsDot(DefaultDirectedGraph<Value<?>, DefaultEdge> graph, Function<Value<?>, String> labelOfValue) {
        IdGenerator idGenerator = new IdGenerator();
        return GraphAsDot.builder(idGenerator::idOf).nodeAttributes(it -> ImmutableMap.builder().putAll(GraphRenderer.colorOf(it)).put((Object)"label", labelOfValue.apply((Value<?>)it)).build()).label("calculation").build().asDot(graph);
    }

    private static Map<String, String> colorOf(Value<?> node) {
        return ImmutableMap.builder().put((Object)"fillcolor", (Object)(node instanceof Unvalidated ? "gray81" : "lightskyblue")).put((Object)"style", (Object)"filled").put((Object)"shape", (Object)"rectangle").build();
    }

    private static class IdGenerator {
        private final Map<Value<?>, String> idMap = new LinkedHashMap();

        private IdGenerator() {
        }

        public String idOf(Value<?> id) {
            return this.idMap.computeIfAbsent(id, it -> "id" + this.idMap.size());
        }
    }
}

