/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.solver;

import com.google.common.base.Preconditions;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.solver.ImmutableContext;
import de.flapdoodle.formula.solver.ValueContainer;
import de.flapdoodle.formula.types.Either;
import de.flapdoodle.formula.validation.ErrorMessage;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Context {
    @Value.Default
    protected ValueContainer values() {
        return ValueContainer.empty();
    }

    @Value.Default
    protected ValueContainer validatedValues() {
        return ValueContainer.empty();
    }

    protected abstract Set<Value<?>> validatedValuesWithErrors();

    protected abstract Map<Value<?>, List<ErrorMessage>> errorMessages();

    public <T> Context addValue(Value<T> id, @Nullable T value) {
        return ImmutableContext.copyOf(this).withValues(this.values().add(id, value));
    }

    @Nullable
    public <T> T getValue(Value<T> id) {
        return this.values().get(id);
    }

    public <T> Context addValidated(Value<T> id, Either<T, List<ErrorMessage>> valueOrErrorMessages) {
        return valueOrErrorMessages.map(value -> ImmutableContext.copyOf(this).withValidatedValues(this.validatedValues().add(id, value)), errors -> ImmutableContext.builder().from(this).validatedValues(this.validatedValues().add(id, null)).addValidatedValuesWithErrors((Value<?>)id).putErrorMessages(id, (List<ErrorMessage>)errors).build());
    }

    @Nullable
    public <T> T getValidated(Value<T> id) {
        return this.validatedValues().get(id);
    }

    public boolean hasValidated(Value<?> id) {
        return this.validatedValues().keys().contains(id);
    }

    public boolean hasValidationErrors(Value<?> id) {
        return this.validatedValuesWithErrors().contains(id);
    }

    public List<ErrorMessage> validationErrors(Value<?> id) {
        return (List)Preconditions.checkNotNull(this.errorMessages().get(id), (String)"no error messages set for %s", id);
    }

    public static Context empty() {
        return ImmutableContext.builder().build();
    }
}

