/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.explain;

import de.flapdoodle.formula.Unvalidated;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.explain.ImmutableCalculationVertex;
import de.flapdoodle.formula.explain.ImmutableValidationVertex;
import de.flapdoodle.formula.explain.ImmutableValueVertex;
import de.flapdoodle.formula.types.HasHumanReadableLabel;
import de.flapdoodle.formula.validation.Validation;
import org.immutables.value.Value;

public abstract class RuleVertex {
    public static <T> RuleVertex value(Value<? extends T> value) {
        return ImmutableValueVertex.of(value);
    }

    public static <T> RuleVertex calculation(Calculation<T> calculation) {
        return ImmutableCalculationVertex.of(calculation);
    }

    public static <T> RuleVertex validation(Validation<T> validation) {
        return ImmutableValidationVertex.of(validation);
    }

    @Value.Immutable
    public static abstract class ValidationVertex<T>
    extends RuleVertex
    implements HasHumanReadableLabel {
        @Value.Parameter
        public abstract Validation<T> calculation();

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.calculation());
        }
    }

    @Value.Immutable
    public static abstract class CalculationVertex<T>
    extends RuleVertex
    implements HasHumanReadableLabel {
        @Value.Parameter
        public abstract Calculation<T> calculation();

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.calculation());
        }
    }

    @Value.Immutable
    public static abstract class ValueVertex<T>
    extends RuleVertex
    implements HasHumanReadableLabel {
        @Value.Parameter
        public abstract Value<T> value();

        @Override
        public String asHumanReadable() {
            Value<T> realValue = this.value() instanceof Unvalidated ? ((Unvalidated)this.value()).wrapped() : this.value();
            return HasHumanReadableLabel.asHumanReadable(realValue);
        }
    }
}

