/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.explain;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.flapdoodle.formula.Rules;
import de.flapdoodle.formula.Unvalidated;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.calculate.CalculationMap;
import de.flapdoodle.formula.explain.RuleVertex;
import de.flapdoodle.formula.types.HasHumanReadableLabel;
import de.flapdoodle.formula.validation.Validation;
import de.flapdoodle.formula.validation.ValidationMap;
import de.flapdoodle.graph.GraphAsDot;
import de.flapdoodle.graph.Graphs;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public abstract class RuleDependencyGraph {
    private RuleDependencyGraph() {
    }

    public static String explain(Rules rules) {
        return RuleDependencyGraph.renderGraphAsDot(RuleDependencyGraph.build(rules));
    }

    private static DefaultDirectedGraph<RuleVertex, DefaultEdge> build(Rules rules) {
        return RuleDependencyGraph.buildGraph(rules.calculations(), rules.validations());
    }

    public static String renderGraphAsDot(DefaultDirectedGraph<RuleVertex, DefaultEdge> graph) {
        return RuleDependencyGraph.renderGraphAsDot(graph, HasHumanReadableLabel::asHumanReadable);
    }

    private static String renderGraphAsDot(DefaultDirectedGraph<RuleVertex, DefaultEdge> graph, Function<RuleVertex, String> labelOfValue) {
        IdGenerator idGenerator = new IdGenerator();
        return GraphAsDot.builder(idGenerator::idOf).nodeAttributes(it -> ImmutableMap.builder().putAll(RuleDependencyGraph.colorOf(it)).put((Object)"label", labelOfValue.apply((RuleVertex)it)).build()).label("rules").build().asDot(graph);
    }

    private static Map<String, String> colorOf(RuleVertex node) {
        return ImmutableMap.builder().put((Object)"fillcolor", (Object)(node instanceof RuleVertex.ValueVertex ? "gray81" : "lightskyblue")).put((Object)"style", (Object)"filled").put((Object)"shape", (Object)"rectangle").build();
    }

    private static DefaultDirectedGraph<RuleVertex, DefaultEdge> buildGraph(CalculationMap calculations, ValidationMap validations) {
        Wrapper builder = new Wrapper();
        Set allSources = (Set)Stream.concat(calculations.values().stream().flatMap(it -> it.sources().stream()), validations.values().stream().flatMap(it -> it.sources().stream())).collect(ImmutableSet.toImmutableSet());
        ImmutableSet validatedOrCalculated = ImmutableSet.builder().addAll(calculations.keys()).addAll(validations.keys()).build();
        Sets.SetView unvalidatedOrCalculated = Sets.difference((Set)allSources, (Set)validatedOrCalculated);
        unvalidatedOrCalculated.forEach(it -> {
            if (!(it instanceof Unvalidated)) {
                builder.add((Value<?>)it, null, null);
            }
        });
        calculations.values().forEach(calculation -> builder.add(calculation.destination(), (Calculation<?>)calculation, null));
        validations.values().forEach(validation -> builder.add(validation.destination(), null, (Validation<?>)validation));
        return builder.build();
    }

    private static class Wrapper {
        private final Graphs.GraphBuilder<RuleVertex, DefaultEdge, DefaultDirectedGraph<RuleVertex, DefaultEdge>> builder = (Graphs.GraphBuilder)Graphs.graphBuilder((Supplier)Graphs.directedGraph()).get();

        private Wrapper() {
        }

        Wrapper add(Value<?> destination, @Nullable Calculation<?> calculation, @Nullable Validation<?> validation) {
            RuleVertex destinationVertex = RuleVertex.value(destination);
            this.builder.addVertex((Object)destinationVertex);
            if (calculation != null) {
                RuleVertex calculationVertex = RuleVertex.calculation(calculation);
                this.builder.addVertex((Object)calculationVertex);
                this.builder.addEdge((Object)calculationVertex, (Object)destinationVertex);
                calculation.sources().forEach(source -> {
                    RuleVertex sourceVertex = RuleVertex.value(source);
                    this.builder.addVertex((Object)sourceVertex);
                    this.builder.addEdge((Object)sourceVertex, (Object)calculationVertex);
                });
            }
            if (validation != null) {
                RuleVertex validationVertex = RuleVertex.validation(validation);
                this.builder.addVertex((Object)validationVertex);
                this.builder.addEdge((Object)validationVertex, (Object)destinationVertex);
                validation.sources().forEach(source -> {
                    RuleVertex sourceVertex = RuleVertex.value(source);
                    this.builder.addVertex((Object)sourceVertex);
                    this.builder.addEdge((Object)sourceVertex, (Object)validationVertex);
                });
            }
            return this;
        }

        public DefaultDirectedGraph<RuleVertex, DefaultEdge> build() {
            return (DefaultDirectedGraph)this.builder.build();
        }
    }

    private static class IdGenerator {
        private final Map<RuleVertex, String> idMap = new LinkedHashMap<RuleVertex, String>();

        private IdGenerator() {
        }

        public String idOf(RuleVertex vertex) {
            return this.idMap.computeIfAbsent(vertex, it -> "id" + this.idMap.size());
        }
    }
}

