/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.calculate;

import com.google.common.base.MoreObjects;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.Calculations;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Calculations.Direct", generator="Immutables")
@Immutable
final class ImmutableDirect<A, X>
extends Calculations.Direct<A, X> {
    private final Value<X> destination;
    private final ValueSource<A> source;
    private final Calculations.F1<A, X> transformation;

    private ImmutableDirect(Value<X> destination, ValueSource<A> source, Calculations.F1<A, X> transformation) {
        this.destination = Objects.requireNonNull(destination, "destination");
        this.source = Objects.requireNonNull(source, "source");
        this.transformation = Objects.requireNonNull(transformation, "transformation");
    }

    private ImmutableDirect(ImmutableDirect<A, X> original, Value<X> destination, ValueSource<A> source, Calculations.F1<A, X> transformation) {
        this.destination = destination;
        this.source = source;
        this.transformation = transformation;
    }

    @Override
    public Value<X> destination() {
        return this.destination;
    }

    @Override
    protected ValueSource<A> source() {
        return this.source;
    }

    @Override
    protected Calculations.F1<A, X> transformation() {
        return this.transformation;
    }

    public final ImmutableDirect<A, X> withDestination(Value<X> value) {
        if (this.destination == value) {
            return this;
        }
        Value<X> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableDirect<A, X>(this, newValue, this.source, this.transformation);
    }

    public final ImmutableDirect<A, X> withSource(ValueSource<A> value) {
        if (this.source == value) {
            return this;
        }
        ValueSource<A> newValue = Objects.requireNonNull(value, "source");
        return new ImmutableDirect<A, X>(this, this.destination, newValue, this.transformation);
    }

    public final ImmutableDirect<A, X> withTransformation(Calculations.F1<A, X> value) {
        if (this.transformation == value) {
            return this;
        }
        Calculations.F1<A, X> newValue = Objects.requireNonNull(value, "transformation");
        return new ImmutableDirect<A, X>(this, this.destination, this.source, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDirect && this.equalTo(0, (ImmutableDirect)another);
    }

    private boolean equalTo(int synthetic, ImmutableDirect<?, ?> another) {
        return this.destination.equals(another.destination) && this.source.equals(another.source) && this.transformation.equals(another.transformation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.transformation.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Direct").omitNullValues().add("destination", this.destination).add("source", this.source).add("transformation", this.transformation).toString();
    }

    public static <A, X> ImmutableDirect<A, X> of(Value<X> destination, ValueSource<A> source, Calculations.F1<A, X> transformation) {
        return new ImmutableDirect<A, X>(destination, source, transformation);
    }

    public static <A, X> ImmutableDirect<A, X> copyOf(Calculations.Direct<A, X> instance) {
        if (instance instanceof ImmutableDirect) {
            return (ImmutableDirect)instance;
        }
        return ImmutableDirect.of(instance.destination(), instance.source(), instance.transformation());
    }
}

