/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.calculate;

import com.google.common.collect.ImmutableList;
import de.flapdoodle.formula.ValueSink;
import de.flapdoodle.formula.ValueSource;
import de.flapdoodle.formula.calculate.Calculation;
import de.flapdoodle.formula.calculate.ImmutableAggregated;
import de.flapdoodle.formula.calculate.ImmutableDirect;
import de.flapdoodle.formula.calculate.ImmutableF1Explained;
import de.flapdoodle.formula.calculate.ImmutableF2Explained;
import de.flapdoodle.formula.calculate.ImmutableMerge2;
import de.flapdoodle.formula.calculate.ImmutableMerge3;
import de.flapdoodle.formula.types.HasHumanReadableLabel;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public abstract class Calculations {
    private Calculations() {
    }

    public static <X> F1<X, X> identity() {
        return a -> a;
    }

    public static <A, R> F1<A, R> explained(F1<A, R> delegate, String explanation) {
        return ImmutableF1Explained.of(delegate, explanation);
    }

    public static <A, B, R> F2<A, B, R> explained(F2<A, B, R> delegate, String explanation) {
        return ImmutableF2Explained.of(delegate, explanation);
    }

    @Value.Immutable
    static abstract class F2Explained<A, B, R>
    implements F2<A, B, R>,
    HasHumanReadableLabel {
        F2Explained() {
        }

        @Value.Parameter
        protected abstract F2<A, B, R> delegate();

        @Value.Parameter
        protected abstract String humanReadable();

        @Override
        @Nullable
        @Value.Auxiliary
        public R apply(@Nullable A a, @Nullable B b) {
            return this.delegate().apply(a, b);
        }

        @Override
        public String asHumanReadable() {
            return this.humanReadable();
        }
    }

    @Value.Immutable
    static abstract class F1Explained<A, R>
    implements F1<A, R>,
    HasHumanReadableLabel {
        F1Explained() {
        }

        @Value.Parameter
        protected abstract F1<A, R> delegate();

        @Value.Parameter
        protected abstract String humanReadable();

        @Override
        @Nullable
        @Value.Auxiliary
        public R apply(@Nullable A a) {
            return this.delegate().apply(a);
        }

        @Override
        public String asHumanReadable() {
            return this.humanReadable();
        }
    }

    @Value.Immutable(builder=false)
    static abstract class Aggregated<S, X>
    implements Calculation<X>,
    HasHumanReadableLabel {
        Aggregated() {
        }

        @Value.Parameter
        protected abstract List<ValueSource<S>> sourceList();

        @Value.Parameter
        protected abstract F1<List<S>, X> aggregation();

        @Override
        public List<? extends ValueSource<?>> sources() {
            return this.sourceList();
        }

        @Override
        public X calculate(Calculation.ValueLookup values) {
            List sourceValues = this.sourceList().stream().map(id -> values.get(id)).collect(Collectors.toList());
            return this.aggregation().apply(sourceValues);
        }

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.aggregation());
        }

        public static <S, X> Aggregated<S, X> with(List<? extends ValueSource<S>> sourceList, ValueSink<X> destination, F1<List<S>, X> aggregation) {
            return ImmutableAggregated.of(destination, sourceList, aggregation);
        }
    }

    @Value.Immutable(builder=false)
    static abstract class Merge3<A, B, C, X>
    implements Calculation<X>,
    HasHumanReadableLabel {
        Merge3() {
        }

        @Value.Parameter
        protected abstract ValueSource<A> a();

        @Value.Parameter
        protected abstract ValueSource<B> b();

        @Value.Parameter
        protected abstract ValueSource<C> c();

        @Value.Parameter
        protected abstract F3<A, B, C, X> transformation();

        @Override
        public List<ValueSource<?>> sources() {
            return ImmutableList.of(this.a(), this.b(), this.c());
        }

        @Override
        public X calculate(Calculation.ValueLookup values) {
            return this.transformation().apply(values.get(this.a()), values.get(this.b()), values.get(this.c()));
        }

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.transformation());
        }

        public static <A, B, C, X> Merge3<A, B, C, X> with(ValueSource<A> a, ValueSource<B> b, ValueSource<C> c, ValueSink<X> destination, F3<A, B, C, X> transformation) {
            return ImmutableMerge3.of(destination, a, b, c, transformation);
        }
    }

    @Value.Immutable(builder=false)
    static abstract class Merge2<A, B, X>
    implements Calculation<X>,
    HasHumanReadableLabel {
        Merge2() {
        }

        @Value.Parameter
        protected abstract ValueSource<A> a();

        @Value.Parameter
        protected abstract ValueSource<B> b();

        @Value.Parameter
        protected abstract F2<A, B, X> transformation();

        @Override
        public List<ValueSource<?>> sources() {
            return ImmutableList.of(this.a(), this.b());
        }

        @Override
        public X calculate(Calculation.ValueLookup values) {
            return this.transformation().apply(values.get(this.a()), values.get(this.b()));
        }

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.transformation());
        }

        public static <A, B, X> Merge2<A, B, X> with(ValueSource<A> a, ValueSource<B> b, ValueSink<X> destination, F2<A, B, X> transformation) {
            return ImmutableMerge2.of(destination, a, b, transformation);
        }
    }

    @Value.Immutable(builder=false)
    static abstract class Direct<A, X>
    implements Calculation<X>,
    HasHumanReadableLabel {
        Direct() {
        }

        @Value.Parameter
        protected abstract ValueSource<A> source();

        @Value.Parameter
        protected abstract F1<A, X> transformation();

        @Override
        public List<ValueSource<?>> sources() {
            return ImmutableList.of(this.source());
        }

        @Override
        public X calculate(Calculation.ValueLookup values) {
            return this.transformation().apply(values.get(this.source()));
        }

        @Override
        public String asHumanReadable() {
            return HasHumanReadableLabel.asHumanReadable(this.transformation());
        }

        public static <A, X> Direct<A, X> with(ValueSource<A> source, ValueSink<X> destination, F1<A, X> transformation) {
            return ImmutableDirect.of(destination, source, transformation);
        }
    }

    @FunctionalInterface
    public static interface F3<A, B, C, R> {
        @Nullable
        public R apply(@Nullable A var1, @Nullable B var2, @Nullable C var3);
    }

    @FunctionalInterface
    public static interface F2<A, B, R>
    extends BiFunction<A, B, R> {
        @Override
        @Nullable
        public R apply(@Nullable A var1, @Nullable B var2);
    }

    @FunctionalInterface
    public static interface F1<A, R>
    extends Function<A, R> {
        @Override
        @Nullable
        public R apply(@Nullable A var1);
    }
}

