/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.formula.calculate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.flapdoodle.formula.Value;
import de.flapdoodle.formula.calculate.Calculation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CalculationMap {
    private final Map<Value<?>, Calculation<?>> map;

    private CalculationMap(Map<Value<?>, Calculation<?>> map) {
        this.map = map;
    }

    public Collection<Calculation<?>> values() {
        return this.map.values();
    }

    public Set<Value<?>> keys() {
        return this.map.keySet();
    }

    public <T> Calculation<T> get(Value<T> key) {
        return this.map.get(key);
    }

    public boolean contains(Value<?> it) {
        return this.map.containsKey(it);
    }

    public CalculationMap add(Calculation<?> calculation) {
        Preconditions.checkArgument((!this.map.containsKey(calculation.destination()) ? 1 : 0) != 0, (String)"calculation already set for %s", calculation);
        return new CalculationMap((Map<Value<?>, Calculation<?>>)ImmutableMap.builder().putAll(this.map).put(calculation.destination(), calculation).build());
    }

    public CalculationMap addAll(List<Calculation<?>> calculations) {
        ImmutableMap newCalculations = Maps.uniqueIndex(calculations, Calculation::destination);
        Sets.SetView duplicates = Sets.intersection((Set)newCalculations.keySet(), this.map.keySet());
        Preconditions.checkArgument((boolean)duplicates.isEmpty(), (String)"calculation already set for %s", (Object)duplicates);
        return new CalculationMap((Map<Value<?>, Calculation<?>>)ImmutableMap.builder().putAll(this.map).putAll((Map)newCalculations).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalculationMap that = (CalculationMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static CalculationMap empty() {
        return new CalculationMap((Map<Value<?>, Calculation<?>>)ImmutableMap.of());
    }
}

