/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fjobilabs.twitter.User;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@JsonIgnoreProperties(ignoreUnknown=true, value={"following", "is_translator", "follow_request_sent", "notifications", "has_extended_profile", "entities", "is_translation_enabled", "translator_type"})
public class UserDTO
implements User {
    private long id;
    private String idStr;
    private String name;
    private String screenName;
    private String location;
    private String url;
    private String description;
    private List<Object> derived;
    @JsonProperty(value="protected")
    private boolean _protected;
    private boolean verified;
    private int followersCount;
    private int friendsCount;
    private int listedCount;
    private int favouritesCount;
    private int statusesCount;
    private OffsetDateTime createdAt;
    private int utcOffset;
    private String timeZone;
    private boolean geoEnabled;
    private Locale lang;
    private boolean contributorsEnabled;
    private String profileBackgroundColor;
    private String profileBackgroundImageUrl;
    private String profileBackgroundImageUrlHttps;
    private boolean profileBackgroundTile;
    private String profileBannerUrl;
    private String profileImageUrl;
    private String profileImageUrlHttps;
    private String profileLinkColor;
    private String profileSidebarBorderColor;
    private String profileSidebarFillColor;
    private String profileTextColor;
    private boolean profileUseBackgroundImage;
    private boolean defaultProfile;
    private boolean defaultProfileImage;
    private List<String> withheldInCountries;
    private String withheldScope;

    UserDTO() {
    }

    public UserDTO(User user) {
        this.id = user.getId();
        if (user.getId() != 0L) {
            this.idStr = Long.toString(user.getId());
        }
        this.name = user.getName();
        this.screenName = user.getScreenName();
        this.location = user.getLocation();
        this.url = user.getUrl();
        this.description = user.getDescription();
        if (user.getDerived() != null) {
            this.derived = new ArrayList<Object>(user.getDerived());
        }
        this._protected = user.isProtected();
        this.verified = user.isVerified();
        this.followersCount = user.getFollowersCount();
        this.friendsCount = user.getFriendsCount();
        this.listedCount = user.getListedCount();
        this.favouritesCount = user.getFavouritesCount();
        this.statusesCount = user.getStatusesCount();
        this.createdAt = user.getCreatedAt();
        this.utcOffset = user.getUtcOffset();
        this.timeZone = user.getTimeZone();
        this.geoEnabled = user.isGeoEnabled();
        this.lang = user.getLang();
        this.contributorsEnabled = user.isContributorsEnabled();
        this.profileBackgroundColor = user.getProfileBackgroundColor();
        this.profileBackgroundImageUrl = user.getProfileBackgroundImageUrl();
        this.profileBackgroundImageUrlHttps = user.getProfileBackgroundImageUrlHttps();
        this.profileBackgroundTile = user.isProfileBackgroundTile();
        this.profileBannerUrl = user.getProfileBannerUrl();
        this.profileImageUrl = user.getProfileImageUrl();
        this.profileImageUrlHttps = user.getProfileImageUrlHttps();
        this.profileLinkColor = user.getProfileLinkColor();
        this.profileSidebarBorderColor = user.getProfileSidebarBorderColor();
        this.profileSidebarFillColor = user.getProfileSidebarFillColor();
        this.profileTextColor = user.getProfileTextColor();
        this.profileUseBackgroundImage = user.isProfileUseBackgroundImage();
        this.defaultProfile = user.isDefaultProfile();
        this.defaultProfileImage = user.isDefaultProfileImage();
        if (user.getWithheldInCountries() != null) {
            this.withheldInCountries = new ArrayList<String>(user.getWithheldInCountries());
        }
        this.withheldScope = user.getWithheldScope();
    }

    public long getId() {
        return this.id;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Object> getDerived() {
        return this.derived;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public int getListedCount() {
        return this.listedCount;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    @JsonFormat(pattern="EEE MMM dd HH:mm:ss Z yyyy", locale="en")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public Locale getLang() {
        return this.lang;
    }

    public boolean isContributorsEnabled() {
        return this.contributorsEnabled;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundImageUrlHttps() {
        return this.profileBackgroundImageUrlHttps;
    }

    public boolean isProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public String getProfileBannerUrl() {
        return this.profileBannerUrl;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public String getProfileImageUrlHttps() {
        return this.profileImageUrlHttps;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public boolean isProfileUseBackgroundImage() {
        return this.profileUseBackgroundImage;
    }

    public boolean isDefaultProfile() {
        return this.defaultProfile;
    }

    public boolean isDefaultProfileImage() {
        return this.defaultProfileImage;
    }

    public List<String> getWithheldInCountries() {
        return this.withheldInCountries;
    }

    public String getWithheldScope() {
        return this.withheldScope;
    }
}

