/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fjobilabs.twitter.Coordinates;
import de.fjobilabs.twitter.Entities;
import de.fjobilabs.twitter.ExtendedEntities;
import de.fjobilabs.twitter.Place;
import de.fjobilabs.twitter.Rule;
import de.fjobilabs.twitter.Tweet;
import de.fjobilabs.twitter.User;
import de.fjobilabs.twitter.dto.CoordinatesDTO;
import de.fjobilabs.twitter.dto.EntitiesDTO;
import de.fjobilabs.twitter.dto.ExtendedEntitiesDTO;
import de.fjobilabs.twitter.dto.PlaceDTO;
import de.fjobilabs.twitter.dto.RuleDTO;
import de.fjobilabs.twitter.dto.UserDTO;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(value={"geo", "contributors", "metadata"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class TweetDTO
implements Tweet {
    private OffsetDateTime createdAt;
    private long id;
    private String idStr;
    private String text;
    private String source;
    private boolean truncated;
    private long inReplyToStatusId;
    private String inReplyToStatusIdStr;
    private long inReplyToUserId;
    private String inReplyToUserIdStr;
    private String inReplyToScreenName;
    private UserDTO user;
    private CoordinatesDTO coordinates;
    private PlaceDTO place;
    private long quotedStatusId;
    private String quotedStatusIdStr;
    @JsonProperty(value="is_quote_status")
    private boolean isQuoteStatus;
    private Tweet quotedStatus;
    private Tweet retweetedStatus;
    private int quoteCount;
    private int replyCount;
    private int retweetCount;
    private int favoriteCount;
    private EntitiesDTO entities;
    private ExtendedEntitiesDTO extendedEntities;
    private boolean favorited;
    private boolean retweeted;
    private boolean possiblySensitive;
    private String filterLevel;
    private Locale lang;
    private List<RuleDTO> matchingRules;
    private Tweet.CurrentUserRetweet currentUserRetweet;
    private Map<String, Object> scopes;
    private boolean withheldCopyright;
    private List<String> withheldCountries;
    private String withheldScope;

    TweetDTO() {
    }

    public TweetDTO(Tweet tweet) {
        this.createdAt = tweet.getCreatedAt();
        this.id = tweet.getId();
        if (tweet.getId() != 0L) {
            this.idStr = Long.toString(tweet.getId());
        }
        this.text = tweet.getText();
        this.source = tweet.getSource();
        this.truncated = tweet.isTruncated();
        this.inReplyToStatusId = tweet.getInReplyToStatusId();
        if (tweet.getInReplyToStatusId() != 0L) {
            this.inReplyToStatusIdStr = Long.toString(tweet.getInReplyToStatusId());
        }
        this.inReplyToUserId = tweet.getInReplyToUserId();
        if (tweet.getInReplyToUserId() != 0L) {
            this.inReplyToUserIdStr = Long.toString(tweet.getInReplyToUserId());
        }
        this.inReplyToScreenName = tweet.getInReplyToScreenName();
        if (tweet.getUser() != null) {
            this.user = new UserDTO(tweet.getUser());
        }
        if (tweet.getCoordinates() != null) {
            this.coordinates = new CoordinatesDTO(tweet.getCoordinates());
        }
        if (tweet.getPlace() != null) {
            this.place = new PlaceDTO(tweet.getPlace());
        }
        this.quotedStatusId = tweet.getQuotedStatusId();
        if (tweet.getQuotedStatusId() != 0L) {
            this.quotedStatusIdStr = Long.toString(tweet.getQuotedStatusId());
        }
        this.isQuoteStatus = tweet.isQuoteStatus();
        if (tweet.getQuotedStatus() != null) {
            this.quotedStatus = new TweetDTO(tweet.getQuotedStatus());
        }
        if (tweet.getRetweetedStatus() != null) {
            this.retweetedStatus = new TweetDTO(tweet.getRetweetedStatus());
        }
        this.quoteCount = tweet.getQuoteCount();
        this.replyCount = tweet.getReplyCount();
        this.retweetCount = tweet.getRetweetCount();
        this.favoriteCount = tweet.getFavoriteCount();
        if (tweet.getEntities() != null) {
            this.entities = new EntitiesDTO(tweet.getEntities());
        }
        if (tweet.getExtendedEntities() != null) {
            this.extendedEntities = new ExtendedEntitiesDTO(tweet.getExtendedEntities());
        }
        this.favorited = tweet.isFavorited();
        this.retweeted = tweet.isRetweeted();
        this.possiblySensitive = tweet.isPossiblySensitive();
        this.filterLevel = tweet.getFilterLevel();
        this.lang = tweet.getLang();
        if (tweet.getMatchingRules() != null) {
            this.matchingRules = tweet.getMatchingRules().stream().map(RuleDTO::new).collect(Collectors.toList());
        }
        if (tweet.getCurrentUserRetweet() != null) {
            this.currentUserRetweet = new CurrentUserRetweetDTO(tweet.getCurrentUserRetweet());
        }
        if (tweet.getScopes() != null) {
            this.scopes = new HashMap<String, Object>(tweet.getScopes());
        }
        this.withheldCopyright = tweet.isWithheldCopyright();
        if (tweet.getWithheldCountries() != null) {
            this.withheldCountries = new ArrayList<String>(tweet.getWithheldCountries());
        }
        this.withheldScope = tweet.getWithheldScope();
    }

    @JsonFormat(pattern="EEE MMM dd HH:mm:ss Z yyyy", locale="en")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public String getInReplyToStatusIdStr() {
        return this.inReplyToStatusIdStr;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToUserIdStr() {
        return this.inReplyToUserIdStr;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public User getUser() {
        return this.user;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public Place getPlace() {
        return this.place;
    }

    public long getQuotedStatusId() {
        return this.quotedStatusId;
    }

    public String getQuotedStatusIdStr() {
        return this.quotedStatusIdStr;
    }

    public boolean isQuoteStatus() {
        return this.isQuoteStatus;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Tweet getQuotedStatus() {
        return this.quotedStatus;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Tweet getRetweetedStatus() {
        return this.retweetedStatus;
    }

    public int getQuoteCount() {
        return this.quoteCount;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    public int getRetweetCount() {
        return this.retweetCount;
    }

    public int getFavoriteCount() {
        return this.favoriteCount;
    }

    public Entities getEntities() {
        return this.entities;
    }

    public ExtendedEntities getExtendedEntities() {
        return this.extendedEntities;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public boolean isRetweeted() {
        return this.retweeted;
    }

    public boolean isPossiblySensitive() {
        return this.possiblySensitive;
    }

    public String getFilterLevel() {
        return this.filterLevel;
    }

    public Locale getLang() {
        return this.lang;
    }

    public List<? extends Rule> getMatchingRules() {
        return this.matchingRules;
    }

    public Tweet.CurrentUserRetweet getCurrentUserRetweet() {
        return this.currentUserRetweet;
    }

    public Map<String, Object> getScopes() {
        return this.scopes;
    }

    public boolean isWithheldCopyright() {
        return this.withheldCopyright;
    }

    public List<String> getWithheldCountries() {
        return this.withheldCountries;
    }

    public String getWithheldScope() {
        return this.withheldScope;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CurrentUserRetweetDTO
    implements Tweet.CurrentUserRetweet {
        private long id;
        private String idStr;

        public CurrentUserRetweetDTO(Tweet.CurrentUserRetweet currentUserRetweet) {
            this.id = currentUserRetweet.getId();
            this.idStr = Long.toString(currentUserRetweet.getId());
        }

        public long getId() {
            return this.id;
        }

        public String getIdStr() {
            return this.idStr;
        }
    }
}

