/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.fjobilabs.twitter.PollEntity;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PollEntityDTO
implements PollEntity {
    private List<OptionDTO> options;
    private Instant endTimestamp;
    private int durationMinutes;

    public PollEntityDTO(PollEntity pollEntity) {
        this.options = pollEntity.getOptions().stream().map(OptionDTO::new).collect(Collectors.toList());
        this.endTimestamp = pollEntity.getEndTimestamp();
        this.durationMinutes = pollEntity.getDurationMinutes();
    }

    public List<? extends PollEntity.Option> getOptions() {
        return this.options;
    }

    public Instant getEndTimestamp() {
        return this.endTimestamp;
    }

    public int getDurationMinutes() {
        return this.durationMinutes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OptionDTO
    implements PollEntity.Option {
        private int position;
        private String text;

        public OptionDTO(PollEntity.Option option) {
            this.position = option.getPosition();
            this.text = option.getText();
        }

        public int getPosition() {
            return this.position;
        }

        public String getText() {
            return this.text;
        }
    }
}

