/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fjobilabs.twitter.Entity;
import de.fjobilabs.twitter.MediaEntity;
import de.fjobilabs.twitter.dto.AbstractEntityDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MediaEntityDTO
extends AbstractEntityDTO
implements MediaEntity {
    private String displayUrl;
    private String expandedUrl;
    private long id;
    private String idStr;
    private String mediaUrl;
    private String mediaUrlHttps;
    private SizesDTO sizes;
    private long sourceStatusId;
    private String sourceStatusIdStr;
    private String type;

    public MediaEntityDTO(MediaEntity mediaEntity) {
        super((Entity)mediaEntity);
        this.displayUrl = mediaEntity.getDisplayURL();
        this.expandedUrl = mediaEntity.getExpandedURL();
        this.id = mediaEntity.getId();
        this.idStr = Long.toString(mediaEntity.getId());
        this.mediaUrl = mediaEntity.getMediaURL();
        this.mediaUrlHttps = mediaEntity.getMediaURLHttps();
        this.sizes = new SizesDTO(mediaEntity.getSizes());
        this.sourceStatusId = mediaEntity.getSourceStatusId();
        this.sourceStatusIdStr = Long.toString(mediaEntity.getSourceStatusId());
        this.type = mediaEntity.getType();
    }

    public String getDisplayURL() {
        return this.displayUrl;
    }

    public String getExpandedURL() {
        return this.expandedUrl;
    }

    public long getId() {
        return this.id;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public String getMediaURL() {
        return this.mediaUrl;
    }

    public String getMediaURLHttps() {
        return this.mediaUrlHttps;
    }

    public MediaEntity.Sizes getSizes() {
        return this.sizes;
    }

    public long getSourceStatusId() {
        return this.sourceStatusId;
    }

    public String getSourceStatusIdStr() {
        return this.sourceStatusIdStr;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public String getURL() {
        return super.getText();
    }

    @Override
    @JsonProperty(value="url")
    public String getText() {
        return super.getText();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class SizesDTO
    implements MediaEntity.Sizes {
        private SizeDTO thumb;
        private SizeDTO large;
        private SizeDTO medium;
        private SizeDTO small;

        public SizesDTO(MediaEntity.Sizes sizes) {
            this.thumb = new SizeDTO(sizes.getThumb());
            this.large = new SizeDTO(sizes.getLarge());
            this.medium = new SizeDTO(sizes.getMedium());
            this.small = new SizeDTO(sizes.getSmall());
        }

        public MediaEntity.Sizes.Size getThumb() {
            return this.thumb;
        }

        public MediaEntity.Sizes.Size getLarge() {
            return this.large;
        }

        public MediaEntity.Sizes.Size getMedium() {
            return this.medium;
        }

        public MediaEntity.Sizes.Size getSmall() {
            return this.small;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public class SizeDTO
        implements MediaEntity.Sizes.Size {
            private int w;
            private int h;
            private String resize;

            public SizeDTO(MediaEntity.Sizes.Size size) {
                this.w = size.getWidth();
                this.h = size.getHeight();
                this.resize = size.getResize();
            }

            @JsonProperty(value="w")
            public int getWidth() {
                return this.w;
            }

            @JsonProperty(value="h")
            public int getHeight() {
                return this.h;
            }

            public String getResize() {
                return this.resize;
            }
        }
    }
}

