/*
 * Decompiled with CFR 0.152.
 */
package de.fjobilabs.twitter.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.fjobilabs.twitter.Entities;
import de.fjobilabs.twitter.HashtagEntity;
import de.fjobilabs.twitter.MediaEntity;
import de.fjobilabs.twitter.PollEntity;
import de.fjobilabs.twitter.SymbolEntity;
import de.fjobilabs.twitter.URLEntity;
import de.fjobilabs.twitter.UserMentionEntity;
import de.fjobilabs.twitter.dto.HashtagEntityDTO;
import de.fjobilabs.twitter.dto.MediaEntityDTO;
import de.fjobilabs.twitter.dto.PollEntityDTO;
import de.fjobilabs.twitter.dto.SymbolEntityDTO;
import de.fjobilabs.twitter.dto.URLEntityDTO;
import de.fjobilabs.twitter.dto.UserMentionEntityDTO;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EntitiesDTO
implements Entities {
    private List<HashtagEntityDTO> hashtags;
    private List<MediaEntityDTO> media;
    private List<URLEntityDTO> urls;
    private List<UserMentionEntityDTO> userMentions;
    private List<SymbolEntityDTO> symbols;
    private List<PollEntityDTO> polls;

    EntitiesDTO() {
    }

    public EntitiesDTO(Entities entities) {
        if (entities.getHashtags() != null) {
            this.hashtags = entities.getHashtags().stream().map(HashtagEntityDTO::new).collect(Collectors.toList());
        }
        if (entities.getMedia() != null) {
            this.media = entities.getMedia().stream().map(MediaEntityDTO::new).collect(Collectors.toList());
        }
        if (entities.getUrls() != null) {
            this.urls = entities.getUrls().stream().map(URLEntityDTO::new).collect(Collectors.toList());
        }
        if (entities.getUserMentions() != null) {
            this.userMentions = entities.getUserMentions().stream().map(UserMentionEntityDTO::new).collect(Collectors.toList());
        }
        if (entities.getSymbols() != null) {
            this.symbols = entities.getSymbols().stream().map(SymbolEntityDTO::new).collect(Collectors.toList());
        }
        if (entities.getPolls() != null) {
            this.polls = entities.getPolls().stream().map(PollEntityDTO::new).collect(Collectors.toList());
        }
    }

    public List<? extends HashtagEntity> getHashtags() {
        return this.hashtags;
    }

    public List<? extends MediaEntity> getMedia() {
        return this.media;
    }

    public List<? extends URLEntity> getUrls() {
        return this.urls;
    }

    public List<? extends UserMentionEntity> getUserMentions() {
        return this.userMentions;
    }

    public List<? extends SymbolEntity> getSymbols() {
        return this.symbols;
    }

    public List<? extends PollEntity> getPolls() {
        return this.polls;
    }
}

